/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary.ui;

import com.arsdigita.glossary.Glossary;

import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;


/**
 * GlossaryHelper class.
 *
 * This is a helper class for the Glossary package.It includes
 * all the static methods and variables.
 * @author <a href="mailto:gautam.chowdhary@devlogics.com">Gautam Chowdhary</a>
 * @version $Revision: #4 $ $Date: 2003/08/15 $
 * @since ACS 4.6.5
 */

public class GlossaryHelper {

    public static final String versionId = "$Id: //apps/glossary/dev/src/com/arsdigita/glossary/ui/GlossaryHelper.java#4 $ by $Author: dennis $ by $DateTime: 2003/08/15 13:46:34 $";

    private static Logger s_log =
        Logger.getLogger(GlossaryHelper.class);

    public static final String GLOSSARY_XML_NS =  "http://www.redhat.com/glossary/1.0";

    public static Glossary getGlossary(HttpServletRequest req) {
        return (Glossary) Application.getCurrentApplication(req);
    }

    public static BigDecimal getGlossaryID (HttpServletRequest req) {
        Glossary glossary = getGlossary(req);
        Assert.assertNotNull(glossary, "glossary");
        return  glossary.getID();
    }


    public static BigDecimal getWordID (HttpServletRequest req) {

        BigDecimal parameterValue = null;
        BigDecimalParameter parameter = new BigDecimalParameter("word_id");

        try {
            parameterValue = (BigDecimal)parameter.transformValue(req);
        }  catch (Exception ex) {
            s_log.error ("",ex);
        }

        return  parameterValue;

    }

}
