/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.glossary;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.glossary.GlossaryWord;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;

public class WordCollection
extends DomainCollection {
    WordCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    public void startsWith(String start) {
        if (start != null) {
            Filter f = this.m_dataCollection.getFilterFactory().compare("upper(word)", 7, ":word");
            f.set("word", (Object)start.toUpperCase());
            this.m_dataCollection.addFilter(f);
        }
    }

    public void exactMatch(String word) {
        Filter f = this.m_dataCollection.addFilter("upper(word) = :word");
        f.set("word", (Object)word.toUpperCase());
    }

    public void duplicates(String word, GlossaryWord gw) {
        this.exactMatch(word);
        if (gw != null) {
            this.m_dataCollection.addNotEqualsFilter("id", (Object)gw.getID());
        }
    }

    public void contains(String search) {
        FilterFactory factory = this.m_dataCollection.getFilterFactory();
        this.m_dataCollection.addFilter((Filter)factory.or().addFilter(factory.contains("word", search, false)).addFilter(factory.contains("definition", search, false)));
    }

    public DomainObject getDomainObject() {
        return this.getWord();
    }

    public GlossaryWord getWord() {
        return new GlossaryWord(this.m_dataCollection.getDataObject());
    }
}

