/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.glossary;

import com.arsdigita.glossary.Glossary;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.AbstractPopulateApp;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.util.Assert;
import com.arsdigita.util.TypedText;
import com.arsdigita.web.ApplicationType;
import java.util.List;

public class PopulateGlossary
extends AbstractPopulateApp
implements PopulateApp {
    private static final String ARGS_DESC = "1 PopulateGlossary arg: numWords";

    public void populateApp(List args) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        Glossary glossary = (Glossary)this.getApp();
        this.validateArgs(args, 1, ARGS_DESC);
        int iWords = (Integer)args.get(0);
        Assert.assertTrue((iWords >= 0 ? 1 : 0) != 0, (String)"iWords must be >= 0");
        String sLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int iNumLetters = sLetters.length();
        for (int i = 0; i < iWords; ++i) {
            txn.beginTxn();
            int iLetterIndex = i % iNumLetters;
            String sWord = sLetters.substring(iLetterIndex, iLetterIndex + 1) + "_Word_" + i;
            String sDef = Utilities.makeText((int)i);
            glossary.createWord(sWord, new TypedText(sDef, "text/plain"));
            this.s_log.info((Object)("added glossary word " + sWord));
            txn.commitTxn();
        }
    }

    public String getArgsDescription() {
        return ARGS_DESC;
    }

    public ApplicationType getAppType() {
        return ApplicationType.retrieveApplicationTypeForApplication((String)"com.arsdigita.glossary.Glossary");
    }

    protected String getPortletType() {
        return "com.arsdigita.glossary.GlossaryLettersPortlet";
    }
}

