/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary.ui;


import com.arsdigita.glossary.util.GlobalizationUtil; 

import com.arsdigita.glossary.GlossaryWord;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ListPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;

import java.math.BigDecimal;

/**
 * Admin view into a single glossary word
 *
 * TODO: edit link
 *
 * @author Kevin Scaldeferri (kevin@arsdigita.com)
 */
class AdminWordView extends CompoundComponent {

    private RequestLocal m_word;
    private ToggleLink m_editLink;

    public AdminWordView(final SingleSelectionModel selection) {

        ActionLink returnLink = new ActionLink( (String) GlobalizationUtil.globalize("cw.glossary.ui.return_to_all_words").localize());
        returnLink.addActionListener(
                                     new ActionListener() {
                                         public void actionPerformed(ActionEvent e) {
                                             selection.clearSelection(e.getPageState());
                                         }
                                     });
        add(returnLink);

        m_word = new RequestLocal() {
            protected Object initialValue(PageState s) {
              try {
                    GlossaryWord gw = new GlossaryWord(
                         new BigDecimal( (String)selection.getSelectedKey(s)));
                         gw.assertPrivilege(PrivilegeDescriptor.READ);
                         return gw;
                    } catch (DataObjectNotFoundException e) {
                        return null;
                    }
                }
            };

        Label word = new Label(new PrintListener() {
                public void prepare(PrintEvent e) {
                    Label l = (Label) e.getTarget();
                    l.setLabel(((GlossaryWord) m_word.get(e.getPageState()))
                               .getWord());
                }
            });

        Label defn = new Label(new PrintListener() {
                public void prepare(PrintEvent e) {
                    Label l = (Label) e.getTarget();
                    l.setLabel(((GlossaryWord) m_word.get(e.getPageState()))
                               .getDefinition().getHTMLText());
                }
            });

        add(new WordView(word, defn));

        ListPanel linkList = new ListPanel(ListPanel.UNORDERED);

        m_editLink = new ToggleLink("Edit this word");
        linkList.add(m_editLink);

        ActionLink deleteLink = new ActionLink( (String) GlobalizationUtil.globalize("cw.glossary.ui.delete_this_word").localize());
        deleteLink.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    final PageState s = e.getPageState();
                    KernelExcursion ex = new KernelExcursion() {
                        protected void excurse() {
                            setEffectiveParty(Kernel.getSystemParty());
                            ((GlossaryWord) m_word.get(s)).delete();
                        }
                    };
                    ex.run();
                    selection.clearSelection(s);
                }
            });
        deleteLink.setConfirmation("This will permanently delete the word."
                                   + " Do you want to do this?");
        linkList.add(deleteLink);
        add(linkList);
    }

    ToggleLink getEditLink() {
        return m_editLink;
    }
}
