/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */
 
package com.arsdigita.glossary;

import com.arsdigita.glossary.ui.GlossaryLettersPortlet;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.portal.apportlet.AppPortletType;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;


/**
 * Glossary Loader
 *
 * @author Aram Kananov &lt;aram@kananov.com&gt;
 * @version $Revision: #1 $ $Date: 2004/03/09 $
 **/
public class Loader extends PackageLoader {
 
 
    public void run(ScriptContext context) {
        ApplicationType glossaryType = ApplicationType.createApplicationType("glossary",
                "Glossary Package", Glossary.BASE_DATA_OBJECT_TYPE);

        // register the stylesheet
        glossaryType.addStylesheet(Stylesheet.createStylesheet(
                "/packages/glossary/xsl/glossary.xsl"));

        // register the dispatcher
        glossaryType.setDispatcherClass(
            "com.arsdigita.glossary.GlossaryDispatcher");

        // register the glossary portlet
        AppPortletType glossaryPortletType = AppPortletType.createAppPortletType("Glossary Letters Portlet",
                AppPortletType.WIDE_PROFILE,
                GlossaryLettersPortlet.BASE_DATA_OBJECT_TYPE);
        glossaryPortletType.setProviderApplicationType(glossaryType);
        glossaryPortletType.setPortalApplication(true);

        //Initialize and mount Glossary application
        Application glossary = com.arsdigita.web.Application.createApplication(glossaryType,
                "glossary", "Glossary", null);
    }
    
    
}
