/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */
 
package com.arsdigita.glossary;


import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.glossary.ui.GlossaryLettersPortlet;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;

/**
 * Glossary Initializer
 *
 * @author Aram Kananov &lt;aram@kananov.com&gt;
 * @version $Revision: #8 $ $Date: 2004/03/09 $
 **/

public class Initializer extends CompoundInitializer{
    
    public Initializer() {
          final String url = RuntimeConfig.getConfig().getJDBCURL();
          final int database = DbHelper.getDatabaseFromURL(url);

          add(new PDLInitializer
              (new ManifestSource
               ("ccm-glossary.pdl.mf",
                new NameFilter(DbHelper.getDatabaseSuffix(database), "pdl"))));

    }
    
    public void init(final DomainInitEvent e) {
        super.init(e);
        
        DomainObjectInstantiator instantiator;
        
        // Register Glossary object
        DomainObjectFactory.registerInstantiator
            (Glossary.BASE_DATA_OBJECT_TYPE,
             new DomainObjectInstantiator () {
                 protected final DomainObject doNewInstance
                     (final DataObject data) {
                     return new Glossary(data);
                 }
             });

    // Register Glossary Portlet object
        DomainObjectFactory.registerInstantiator
            (GlossaryLettersPortlet.BASE_DATA_OBJECT_TYPE,
             new DomainObjectInstantiator () {
                 protected final DomainObject doNewInstance
                     (final DataObject data) {
                     return new GlossaryLettersPortlet(data);
                 }
             });


    }
}
