/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.Application;
import com.arsdigita.util.TypedText;
import com.arsdigita.kernel.permissions.PermissionService;

import java.math.BigDecimal;

/**
 * Glossary Domain Object.
 *
 * @author <a href="mailto:gautam.chowdhary@devlogics.com">Gautam Chowdhary</a>
 * @version $Revision: #4 $ $Date: 2003/08/26 $
 * @since ACS 4.6.5
 *
 */

public class Glossary extends Application {
    public static final String versionId = "$Id: //apps/glossary/dev/src/com/arsdigita/glossary/Glossary.java#4 $ by $Author: jparsons $ by  $DateTime: 2003/08/26 09:40:40 $";

    /* Logging Category  */
    private static final org.apache.log4j.Logger log =
        org.apache.log4j.Logger.getLogger(Glossary.class);

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.glossary.Glossary";

    public static Glossary create(String urlName, String title,
                                  Application parent) {
        return (Glossary) Application.createApplication
            (BASE_DATA_OBJECT_TYPE, urlName, title, parent);
    }

    public Glossary(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Glossary(DataObject dataObject) {
        super(dataObject);
    }

    /**
     * Constructor. Retrieves a Glossary instance, retrieving an existing
     * glossary from the database with an ID responding to key.
     *
     * @param key The ID for the object to be retrieved.
     * object.
     *
     * @exception DataObjectNotFoundException Thrown if we cannot
     * retrieve a data object for the specified OID
     *
     **/
    public Glossary(BigDecimal key) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, key));
    }


    /**
     * Returns the appropriate object type for a Glossary so that proper
     * type validation will occur when retrieving Glossary's by  OID
     *
     * @return The fully qualitifed name of of the base data object
     * type for the Glossary object type.
     **/
    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public GlossaryWord createWord(String word, TypedText definition) {
        GlossaryWord gw = new GlossaryWord(word, definition);
        gw.setGlossary(this);
        PermissionService.setContext(gw, this);
        return gw;
    }

    public void removeWord(GlossaryWord word) {
        remove("words", word);
    }

    /**
     * gets all the words in this glossary
     */
    public WordCollection getWordList() {
        return getWordList(null);
    }

    /**
     * gets all the words in this glossary which start with the specified
     * string.  If the string is null, then all words are retrieved.
     */
    public WordCollection getWordList(String start) {
        DataAssociation wordList = (DataAssociation)get("words");
        WordCollection words =
            new WordCollection(wordList.getDataCollection());
        words.startsWith(start);
        return words;
    }


}
