/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;

/**
 * Displays the list of words in the glossary.  Users can restrict to
 * words starting with a particular letter
 *
 * @author Kevin Scaldeferri (kevin@arsdigita.com)
 * @version $Revision: #2 $ $Date: 2003/08/15 $
 * @since ACS 4.6.5
 */

public class GlossaryUserView extends SimpleContainer
    implements ActionListener {

    private TabbedPane m_letters;
    private ParameterModel m_startsWith;

    private static final int ASCII_A = 65;
    private static final int ASCII_Z = 90;

    public GlossaryUserView() {

        m_letters = new TabbedPane();

        for (int i = ASCII_A ; i <= ASCII_Z; i++) {
            String start = "" + (char) i;
            m_letters.addTab(start, buildWordList(start));
        }

        m_letters.addTab("All", buildWordList(null));
        add(m_letters);
    }

    public void register(Page page) {
        super.register(page);
        m_startsWith = new IntegerParameter("starts_with");
        page.addGlobalStateParam(m_startsWith);
        page.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        // if we are coming from the LettersPortlet, we need to
        // set the selected pane
        if (s.getValue(m_startsWith) != null) {
            int i = ((Integer)s.getValue(m_startsWith)).intValue();
            m_letters.setSelectedIndex(s, i - ASCII_A);
            // unset so further use of the tabbed pane works
            s.setValue(m_startsWith, null);
        }
    }

    private Component buildWordList(String start) {
        return new WordList(start);
    }
}
