/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary.ui;


import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.DefaultListCellRenderer;

/**
 * GlossaryAdminView class.
 * A reusable Bebop component to display the Admin pages
 * for an Glossary.
 *
 * @author Kevin Scaldeferri (kevin@arsdigita.com)
 * @version $Revision: #2 $ $Date: 2003/08/15 $
 * @since ACS 4.6.5
 */

public class GlossaryAdminView extends ModalContainer
    implements ActionListener {

    private Container m_words;
    private ToggleLink m_newLink;
    private AdminWordView m_wordView;
    private GlossaryWordEntryForm m_editForm;
    private SingleSelectionModel m_selection;

    public GlossaryAdminView() {
        m_words = new SimpleContainer();
        List wordList = new WordList(null);
        wordList.setClassAttr(null);
        wordList.setCellRenderer(new DefaultListCellRenderer());
        m_selection = wordList.getSelectionModel();
        m_words.add(wordList);

        m_newLink = new ToggleLink("Add a new Glossary Item");
        m_words.add(m_newLink);
        add(m_words);
        setDefaultComponent(m_words);

        m_wordView = new AdminWordView(m_selection);
        add(m_wordView);

        m_editForm = new GlossaryWordEntryForm(m_selection);
        m_editForm.addCompletionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    PageState s = e.getPageState();
                    if (m_selection.isSelected(s)) {
                        m_wordView.getEditLink().setSelected(s, false);
                        setVisibleComponent(s, m_wordView);
                    } else {
                        m_newLink.setSelected(s, false);
                        setVisibleComponent(s, m_words);
                    }
                }
            });

        add(m_editForm);
    }

    public void register(Page p) {
        super.register(p);
        p.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        if (m_selection.isSelected(s)) {
            if (m_wordView.getEditLink().isSelected(s)) {
                setVisibleComponent(s, m_editForm);
            } else {
                setVisibleComponent(s, m_wordView);
            }
        } else if (m_newLink.isSelected(s)) {
            setVisibleComponent(s, m_editForm);
        } else {
            setVisibleComponent(s, m_words);
        }
    }
}
