/*
 * Copyright (C) 2001, 2002 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 */
 
package com.arsdigita.glossary;

import java.util.List;

import com.arsdigita.glossary.ui.GlossaryLettersPortlet;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.AbstractPopulateApp;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.util.Assert;
import com.arsdigita.util.TypedText;
import com.arsdigita.web.ApplicationType;

/**
 * @author bche
 */
public class PopulateGlossary extends AbstractPopulateApp implements PopulateApp {
    private static final String ARGS_DESC = "1 PopulateGlossary arg: numWords";

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#populateApp(java.util.List)
     */
    public void populateApp(List args) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();

        Glossary glossary = (Glossary) getApp();

        //validate the arguments
        this.validateArgs(args, 1, ARGS_DESC);
        int iWords = ((Integer)args.get(0)).intValue();        
        Assert.assertTrue(iWords >= 0, "iWords must be >= 0");

	//cycle through letters of the alphabet for the words
	String sLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	int iNumLetters = sLetters.length();
        
        for (int i=0; i < iWords; i ++) {
            txn.beginTxn();
	    int iLetterIndex = i % iNumLetters;
            String sWord = sLetters.substring(iLetterIndex, iLetterIndex+1) + "_Word_" + i;
            String sDef = Utilities.makeText(i);
            
            glossary.createWord(sWord, new TypedText(sDef, TypedText.TEXT_PLAIN));
            s_log.info("added glossary word " + sWord);
            
            txn.commitTxn();                
        }

    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getArgsDescription()
     */
    public String getArgsDescription() {
        return ARGS_DESC;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getAppType()
     */
    public ApplicationType getAppType() {
        return ApplicationType.retrieveApplicationTypeForApplication(
                        Glossary.BASE_DATA_OBJECT_TYPE);
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.AbstractPopulateApp#getPortletType()
     */
    protected String getPortletType() {
        return GlossaryLettersPortlet.BASE_DATA_OBJECT_TYPE;
    }

}
