/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.glossary.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ListPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.glossary.GlossaryWord;
import com.arsdigita.glossary.ui.WordView;
import com.arsdigita.glossary.util.GlobalizationUtil;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import java.math.BigDecimal;

class AdminWordView
extends CompoundComponent {
    private RequestLocal m_word;
    private ToggleLink m_editLink;

    public AdminWordView(final SingleSelectionModel selection) {
        ActionLink returnLink = new ActionLink((String)GlobalizationUtil.globalize("cw.glossary.ui.return_to_all_words").localize());
        returnLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                selection.clearSelection(e.getPageState());
            }
        });
        this.add((Component)returnLink);
        this.m_word = new RequestLocal(){

            protected Object initialValue(PageState s) {
                try {
                    GlossaryWord gw = new GlossaryWord(new BigDecimal((String)selection.getSelectedKey(s)));
                    gw.assertPrivilege(PrivilegeDescriptor.READ);
                    return gw;
                }
                catch (DataObjectNotFoundException e) {
                    return null;
                }
            }
        };
        Label word = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label l = (Label)e.getTarget();
                l.setLabel(((GlossaryWord)((Object)AdminWordView.this.m_word.get(e.getPageState()))).getWord());
            }
        });
        Label defn = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                Label l = (Label)e.getTarget();
                l.setLabel(((GlossaryWord)((Object)AdminWordView.this.m_word.get(e.getPageState()))).getDefinition().getHTMLText());
            }
        });
        this.add((Component)new WordView(word, defn));
        ListPanel linkList = new ListPanel(false);
        this.m_editLink = new ToggleLink("Edit this word");
        linkList.add((Component)this.m_editLink);
        ActionLink deleteLink = new ActionLink((String)GlobalizationUtil.globalize("cw.glossary.ui.delete_this_word").localize());
        deleteLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                KernelExcursion ex = new KernelExcursion(this, s){
                    private final /* synthetic */ PageState val$s;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$s = val$s;
                    }

                    protected void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        ((GlossaryWord)((Object)AdminWordView.access$000(5.access$100(this.this$1)).get(this.val$s))).delete();
                    }
                };
                ex.run();
                selection.clearSelection(s);
            }

            static /* synthetic */ AdminWordView access$100(5 x0) {
                return x0.AdminWordView.this;
            }
        });
        deleteLink.setConfirmation("This will permanently delete the word. Do you want to do this?");
        linkList.add((Component)deleteLink);
        this.add((Component)linkList);
    }

    ToggleLink getEditLink() {
        return this.m_editLink;
    }
}

