/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.glossary.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.glossary.Glossary;
import com.arsdigita.glossary.GlossaryWord;
import com.arsdigita.glossary.WordCollection;
import com.arsdigita.glossary.ui.GlossaryHelper;
import com.arsdigita.glossary.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.TextTypeWidget;
import com.arsdigita.util.TypedText;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class GlossaryWordEntryForm
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$glossary$ui$GlossaryWordEntryForm == null ? (class$com$arsdigita$glossary$ui$GlossaryWordEntryForm = GlossaryWordEntryForm.class$("com.arsdigita.glossary.ui.GlossaryWordEntryForm")) : class$com$arsdigita$glossary$ui$GlossaryWordEntryForm));
    private RequestLocal m_word;
    static /* synthetic */ Class class$com$arsdigita$glossary$ui$GlossaryWordEntryForm;

    public GlossaryWordEntryForm(final SingleSelectionModel selection) {
        super("GlossaryWordEntry");
        this.setMethod("post");
        this.m_word = new RequestLocal(){

            protected Object initialValue(PageState s) {
                try {
                    if (selection.isSelected(s)) {
                        return new GlossaryWord(new BigDecimal((String)selection.getSelectedKey(s)));
                    }
                    return null;
                }
                catch (DataObjectNotFoundException e) {
                    return null;
                }
            }
        };
        this.add((Component)new Label(GlobalizationUtil.globalize("cw.glossary.ui.word")));
        StringParameter word = new StringParameter("word");
        word.addParameterListener((ParameterListener)new NotEmptyValidationListener());
        TextField txt_word = new TextField((ParameterModel)word);
        txt_word.setMaxLength(40);
        this.add((Component)txt_word);
        this.add((Component)new Label(GlobalizationUtil.globalize("cw.glossary.ui.definition")));
        StringParameter defn = new StringParameter("definition");
        defn.addParameterListener((ParameterListener)new NotEmptyValidationListener());
        defn.addParameterListener((ParameterListener)new StringLengthValidationListener(4000));
        this.add((Component)new TextArea((ParameterModel)defn, 4, 40, 2));
        this.add((Component)new Label(GlobalizationUtil.globalize("cw.glossary.ui.text_type")));
        StringParameter textTypeParameter = new StringParameter("definitionTextType");
        this.add((Component)new TextTypeWidget((ParameterModel)textTypeParameter));
        this.add((Component)new Submit("Save"), 66);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState s = e.getPageState();
        HttpServletRequest req = s.getRequest();
        GlossaryWord gw = (GlossaryWord)((Object)this.m_word.get(s));
        if (gw != null) {
            data.put((Object)"word", (Object)gw.getWord());
            data.put((Object)"definition", (Object)gw.getDefinition().getText());
            data.put((Object)"definitionTextType", (Object)gw.getDefinition().getType());
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState s = e.getPageState();
        HttpServletRequest req = s.getRequest();
        String word = (String)data.get((Object)"word");
        word = word.toUpperCase();
        GlossaryWord gw = (GlossaryWord)((Object)this.m_word.get(s));
        Glossary glossary = GlossaryHelper.getGlossary(req);
        WordCollection words = glossary.getWordList();
        words.duplicates(word, gw);
        if (words.next()) {
            data.addError("word", "This word is already in the glossary");
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState s = e.getPageState();
        HttpServletRequest req = s.getRequest();
        GlossaryWord glossaryWord = (GlossaryWord)((Object)this.m_word.get(s));
        String word = (String)data.get((Object)"word");
        String definition = (String)data.get((Object)"definition");
        String definitionTextType = (String)data.get((Object)"definitionTextType");
        if (glossaryWord != null) {
            glossaryWord.setWord(word);
            glossaryWord.setDefinition(new TypedText(definition, definitionTextType));
            glossaryWord.save();
        } else {
            Glossary glossary = GlossaryHelper.getGlossary(req);
            glossaryWord = glossary.createWord(word, new TypedText(definition, definitionTextType));
            glossaryWord.save();
        }
        this.fireCompletionEvent(e.getPageState());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

