/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.glossary.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.glossary.ui.WordList;

public class GlossaryUserView
extends SimpleContainer
implements ActionListener {
    private TabbedPane m_letters = new TabbedPane();
    private ParameterModel m_startsWith;
    private static final int ASCII_A = 65;
    private static final int ASCII_Z = 90;

    public GlossaryUserView() {
        for (int i = 65; i <= 90; ++i) {
            String start = "" + (char)i;
            this.m_letters.addTab(start, this.buildWordList(start));
        }
        this.m_letters.addTab("All", this.buildWordList(null));
        this.add((Component)this.m_letters);
    }

    public void register(Page page) {
        super.register(page);
        this.m_startsWith = new IntegerParameter("starts_with");
        page.addGlobalStateParam(this.m_startsWith);
        page.addActionListener((ActionListener)this);
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        if (s.getValue(this.m_startsWith) != null) {
            int i = (Integer)s.getValue(this.m_startsWith);
            this.m_letters.setSelectedIndex(s, i - 65);
            s.setValue(this.m_startsWith, null);
        }
    }

    private Component buildWordList(String start) {
        return new WordList(start);
    }
}

