/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.glossary.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.DefaultListCellRenderer;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.glossary.ui.AdminWordView;
import com.arsdigita.glossary.ui.GlossaryWordEntryForm;
import com.arsdigita.glossary.ui.WordList;

public class GlossaryAdminView
extends ModalContainer
implements ActionListener {
    private Container m_words = new SimpleContainer();
    private ToggleLink m_newLink;
    private AdminWordView m_wordView;
    private GlossaryWordEntryForm m_editForm;
    private SingleSelectionModel m_selection;

    public GlossaryAdminView() {
        WordList wordList = new WordList(null);
        wordList.setClassAttr(null);
        wordList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer());
        this.m_selection = wordList.getSelectionModel();
        this.m_words.add((Component)wordList);
        this.m_newLink = new ToggleLink("Add a new Glossary Item");
        this.m_words.add((Component)this.m_newLink);
        this.add((Component)this.m_words);
        this.setDefaultComponent((Component)this.m_words);
        this.m_wordView = new AdminWordView(this.m_selection);
        this.add((Component)this.m_wordView);
        this.m_editForm = new GlossaryWordEntryForm(this.m_selection);
        this.m_editForm.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                if (GlossaryAdminView.this.m_selection.isSelected(s)) {
                    GlossaryAdminView.this.m_wordView.getEditLink().setSelected(s, false);
                    GlossaryAdminView.this.setVisibleComponent(s, (Component)GlossaryAdminView.this.m_wordView);
                } else {
                    GlossaryAdminView.this.m_newLink.setSelected(s, false);
                    GlossaryAdminView.this.setVisibleComponent(s, (Component)GlossaryAdminView.this.m_words);
                }
            }
        });
        this.add((Component)this.m_editForm);
    }

    public void register(Page p) {
        super.register(p);
        p.addActionListener((ActionListener)this);
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        if (this.m_selection.isSelected(s)) {
            if (this.m_wordView.getEditLink().isSelected(s)) {
                this.setVisibleComponent(s, (Component)this.m_editForm);
            } else {
                this.setVisibleComponent(s, (Component)this.m_wordView);
            }
        } else if (this.m_newLink.isSelected(s)) {
            this.setVisibleComponent(s, (Component)this.m_editForm);
        } else {
            this.setVisibleComponent(s, (Component)this.m_words);
        }
    }
}

