/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.glossary.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.glossary.GlossaryWord;
import com.arsdigita.glossary.WordCollection;
import com.arsdigita.glossary.ui.GlossaryHelper;
import com.arsdigita.glossary.ui.WordView;

class WordList
extends List {
    public WordList(final String start) {
        this.setClassAttr("definition");
        this.setModelBuilder((ListModelBuilder)new AbstractListModelBuilder(){

            public ListModel makeModel(List l, PageState state) {
                return new WordListModel(start, state);
            }
        });
        this.setCellRenderer(new WordCellRenderer());
    }

    private class WordCellRenderer
    implements ListCellRenderer {
        private WordCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            return new WordView((GlossaryWord)((Object)value));
        }
    }

    private class WordListModel
    implements ListModel {
        WordCollection m_words = null;

        public WordListModel(String start, PageState state) {
            this.m_words = GlossaryHelper.getGlossary(state.getRequest()).getWordList(start);
        }

        public Object getElement() {
            return this.m_words.getWord();
        }

        public String getKey() {
            return this.m_words.getWord().getID().toString();
        }

        public boolean next() {
            return this.m_words.next();
        }
    }
}

