/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.messaging.MessageThread;

import com.arsdigita.tools.junit.framework.BaseTestCase;

public class ThreadSubscriptionTest extends BaseTestCase {

    public static final String versionId = "$Id: //apps/forum/dev/test/src/com/arsdigita/forum/ThreadSubscriptionTest.java#4 $ by $Author: dan $, $DateTime: 2003/09/09 11:53:02 $";

    private ThreadSubscription m_subscription;
    private MessageThread m_thread;

    public ThreadSubscriptionTest(String name) {
        super(name);
    }

    public static void main(String args[]) {
        junit.textui.TestRunner.run(ThreadSubscriptionTest.class);
    }

    public void setUp() {
        m_subscription = new ThreadSubscription();

        m_thread = createThread();
        m_subscription.setThread(m_thread);

        m_subscription.save();
    }

    public void testSubscriptionCreate() {
        assertEquals(m_thread, m_subscription.getThreadReal());
    }

    public void testSubscriptionRetrieve() {

        ThreadSubscription subscription2 = null;
        try {
            subscription2 =
                new ThreadSubscription(m_subscription.getOID());
        } catch (DataObjectNotFoundException e) {
            fail("couldn't retrieve bboard subscription after we saved it");
        }

        assertEquals(m_thread, subscription2.getThreadReal());

    }

    public static MessageThread createThread() {
        Post msg = Post.create(createForum());
        msg.setSubject("the subject");
        msg.setBody("the body", "text/plain");
        msg.setFrom(BboardSuite.createUser());
        msg.save();
        return msg.getThread();
    }

    private static Forum createForum() {
        Forum forum =
            Forum.create("subscription_test", "Subscription Test Forum",
                         null);
        forum.setDescription("Subscription Test Description");
        forum.save();

        return forum;
    }

    public void testGetThreadSubscription() {
        assertEquals(m_subscription,
                     ThreadSubscription.getThreadSubscription(m_thread));
    }

    public void testGetUserSubs() {
        User user = BboardSuite.createUser();
        m_subscription.subscribe(user);
        m_subscription.save();

        DomainCollection subs = ThreadSubscription.getSubsForUser(user);

        boolean found = false;
        while (subs.next()) {
            if (subs.getDomainObject().equals(m_subscription)) {
                found = true;
            }
        }

        assertTrue("Didn't find the ThreadSubscription for our user", found);
    }
}
