/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;


import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataCollection;

import com.arsdigita.kernel.User;

import com.arsdigita.web.Application;

import com.arsdigita.tools.junit.framework.BaseTestCase;

/**
 * Unit tests for forum subscriptions
 *
 * @author <a href="mailto:manu.nath@devlogics.com">Manu R Nath</a>
 * @version $Revision: #5 $ $Date: 2003/09/09 $
 * @since ACS 4.6.5
 */

public class SubscriptionTest extends BaseTestCase {

    public static final String versionId = "$Id: //apps/forum/dev/test/src/com/arsdigita/forum/SubscriptionTest.java#5 $ by $author$ by $DateTime: 2003/09/09 11:53:02 $";

    private ForumSubscription m_subscription;
    private Forum m_bboard;

    public SubscriptionTest(String name) {
        super(name);
    }


    /**
     * Main method required to make this test runnable.
     */

    public static void main(String args[]) {
        junit.textui.TestRunner.run(ForumTest.class);
    }

    public void setUp() {
        m_bboard = createForum();
        m_subscription = new ForumSubscription(m_bboard);
        m_subscription.save();
    }

    // tests Forum Subscription's gets, sets and associations
    public void testSubscriptionSmokeTest() {

        ForumSubscription subscription2 = null;
        try {
            subscription2 =
                new ForumSubscription(m_subscription.getID());
        } catch (DataObjectNotFoundException e) {
            fail("couldn't retrieve bboard subscription after we saved it");
        }

        assertEquals(m_bboard, subscription2.getForum());

        /// test the association from bboardForum to subscription

        DataCollection dc = m_bboard.getSubscriptions();
        dc.addEqualsFilter("id", m_subscription.getID());
        assertEquals(1L, dc.size());

        while (dc.next()) {
            ForumSubscription s = new ForumSubscription(dc.getDataObject());
            assertEquals(m_subscription, s);
        }

    }

    public void testMembers() {
        User user = BboardSuite.createUser();
        assertTrue(! m_subscription.isSubscribed(user));
        m_subscription.subscribe(user);
        m_subscription.save();
        assertTrue(m_subscription.isSubscribed(user));
        m_subscription.unsubscribe(user);
        m_subscription.save();
        assertTrue(! m_subscription.isSubscribed(user));
    }

    public void testSendNotification() {
        m_subscription.sendNotification(createMsg(m_bboard));
    }


    private static Forum createForum() {
        /*
         * don't use Forum.create() because that creates subscriptions
         * which interfere with these tests.
         */

        Forum bboard = (Forum) Application.createApplication
            (Forum.BASE_DATA_OBJECT_TYPE,
             "subscription_test",
             "Subscription Test Forum",
             null);
        bboard.setDescription("Subscription Test Description");
        bboard.save();

        return bboard;
    }

    public static Post createMsg(Forum bboard) {
        Post msg = Post.create(bboard);
        msg.setSubject("the subject");
        msg.setBody("the body", "text/plain");
        msg.setFrom(BboardSuite.createUser());
        msg.save();
        return msg;
    }
}
