/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.User;
import com.arsdigita.tools.junit.extensions.BaseTestSetup;
import com.arsdigita.tools.junit.extensions.CoreTestSetup;
import com.arsdigita.tools.junit.framework.PackageTestSuite;
import junit.framework.Test;

/**
 * Forum test suite.
 *
 * @author <a href="mailto:manu.nath@devlogics.com">Manu R Nath</a>
 * @version $Revision: #5 $ $Date: 2004/01/09 $
 * @since ACS 4.6.5
 */

public class BboardSuite extends PackageTestSuite {

    public BboardSuite() {
        super();
    }

    public BboardSuite(Class theClass) {
        super(theClass);
    }

    public BboardSuite(String name) {
        super(name);
    }


    public static Test suite() {
        BboardSuite suite = new BboardSuite();
        populateSuite(suite);

        BaseTestSetup wrapper = new CoreTestSetup(suite);
        return wrapper;
    }


    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static  User createUser() {

        User user = new User();
        user.getPersonName().setGivenName("test-given-name");
        user.getPersonName().setFamilyName("test-family-name");

        String email = "test-user-" + user.getID() + "@localhost";
        user.setPrimaryEmail(new EmailAddress(email));
        user.save();

        return user;
    }

}
