/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.Page;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Forum;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.util.Assert;
import java.io.IOException;
import org.apache.log4j.Logger;

/**
 * Class ReplyToPostForm
 *
 * @author Jon Orris (jorris@arsdigita.com)
 *
 * @version $Revision #1 $DateTime: 2003/09/15 13:58:12 $
 */
public class ReplyToPostForm extends PostForm  {
    public static final String versionId =
        "$Id: //apps/forum/dev/src/com/arsdigita/forum/ui/ReplyToPostForm.java#6 $" +
        "$Author: dan $" +
        "$DateTime: 2003/09/15 13:58:12 $";

    private static final Logger s_log = Logger.getLogger
        (ReplyToPostForm.class);


    private ACSObjectSelectionModel m_parent;


    public ReplyToPostForm(ACSObjectSelectionModel parent) {
        super("replyPostForm");
        m_parent = parent;
        setupComponent();
    }

    public void register(Page p) {
        super.register(p);
        
        p.addGlobalStateParam(m_parent.getStateParameter());
    }


    protected Post getPost(PageState state,
                           boolean create) {
        if (create) {
            Post post = (Post)((Post)m_parent.getSelectedObject(state)).replyTo();
            post.setFrom(Kernel.getContext().getParty());
            return post;
        }
        return null;
   }

    protected Container dataEntryStep() {
        Container entryStep =  super.dataEntryStep();
        MessageView replyTo = new MessageView(m_parent);
        entryStep.add(replyTo);

        return entryStep;
    }
    
    protected void initWidgets(PageState state,
                               Post post) {
        super.initWidgets(state, post);

        Post parent = (Post)m_parent.getSelectedObject(state);
        String prefix  = "Re:";
        String subject = parent.getSubject();
        
        if (subject.length() < 3 ||
            prefix.equalsIgnoreCase(subject.substring(0,3))) {
            setSubject(state, subject);
        } else {
            setSubject(state, prefix + " " + subject);
        }
    }
    
    protected void processWidgets(PageState state,
                                  Post post) {
        super.processWidgets(state, post);

        ForumContext ctx = ForumContext.getContext(state);
        Forum forum = ctx.getForum();

        if (forum.isModerated() &&
            !ctx.canModerate()) {
            post.setStatus(Post.PENDING);
        } else {
            post.setStatus(Post.APPROVED);
        }

        post.setRefersTo(forum);
    }

}
