-- Since:   2003-06-03
-- Version: $Id: //apps/forum/dev/sql/ccm-forum/upgrade/default/forum-moderation.sql#1 $


alter table forum_forums
add (
is_moderated          integer
                      constraint forum_moderated_nn
                      not null);

alter table forum_subscriptions 
add (
is_moderated                  integer
                              constraint forum_is_moderation_alert_nn 
                              not null);

create table forum_posts (
    post_id INTEGER not null
        constraint forum_posts_post_id_p_7qlj5
          primary key,
        -- referential constraint for post_id deferred due to circular dependencies
    moderator INTEGER,
        -- referential constraint for moderator deferred due to circular dependencies
    status CHAR(20) not null
);

alter table forum_posts add 
    constraint forum_posts_moderator_f_j008r foreign key (moderator)
      references parties(party_id);
alter table forum_posts add 
    constraint forum_posts_post_id_f_x7pw7 foreign key (post_id)
      references messages(message_id) on delete cascade;

-- Fill the new attributes
update forum_forums
       set is_moderated = 0;


insert into forum_posts
(post_id, status)
select message_id, 'approved' 
from  messages m , forum_forums f
where m.object_id = f.forum_id;

