/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.ui.admin.UserPicker;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public abstract class GroupMemberPicker
extends UserPicker {
    private StringParameter m_restrictParam;
    private SingleSelect m_restrict;
    private Option m_both;
    private Option m_users;
    private Option m_groups;

    protected void addWidgets() {
        this.m_restrictParam = new StringParameter("restrict");
        this.m_restrict = new SingleSelect("restrict1");
        this.m_both = new Option("both", "Users & Groups");
        this.m_users = new Option("users", "Users Only");
        this.m_groups = new Option("groups", "Groups Only");
        this.m_restrict.addOption(this.m_both);
        this.m_restrict.addOption(this.m_users);
        this.m_restrict.addOption(this.m_groups);
        this.m_restrict.setOptionSelected(this.m_users);
        BoxPanel opt = new BoxPanel(1);
        opt.add((Component)new Label("Search for"));
        opt.add((Component)this.m_restrict);
        this.add((Component)opt);
        super.addWidgets();
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_restrictParam);
    }

    public void init(FormSectionEvent e) {
        PageState ps = e.getPageState();
        super.init(e);
        this.m_restrict.setValue(ps, ps.getValue((ParameterModel)this.m_restrictParam));
    }

    public void process(FormSectionEvent e) {
        PageState ps = e.getPageState();
        super.process(e);
        ps.setValue((ParameterModel)this.m_restrictParam, this.m_restrict.getValue(ps));
    }

    protected abstract Group getGroup(PageState var1);

    protected DataQuery getUsers(PageState ps, String search) {
        String bdot = "com.arsdigita.kernel.Party";
        if (this.m_users.getValue().equals(ps.getValue((ParameterModel)this.m_restrictParam))) {
            bdot = "com.arsdigita.kernel.User";
        } else if (this.m_groups.getValue().equals(ps.getValue((ParameterModel)this.m_restrictParam))) {
            bdot = "com.arsdigita.kernel.Group";
        }
        DataCollection parties = SessionManager.getSession().retrieve(bdot);
        CompoundFilter or = parties.getFilterFactory().or();
        Filter nameFilter = parties.getFilterFactory().simple("lower(displayName) like lower(:term)");
        nameFilter.set("term", (Object)("%" + search + "%"));
        Filter emailFilter = parties.getFilterFactory().simple("lower(primaryEmail) like lower(:term)");
        emailFilter.set("term", (Object)("%" + search + "%"));
        or.addFilter(nameFilter);
        or.addFilter(emailFilter);
        parties.addFilter((Filter)or);
        parties.addOrder("displayName");
        return parties;
    }

    protected String getDisplayName(DataQuery q) {
        DataObject party = ((DataCollection)q).getDataObject();
        return (String)party.get("displayName");
    }

    protected String getKey(DataQuery q) {
        DataObject party = ((DataCollection)q).getDataObject();
        return party.get("id").toString();
    }

    protected void addUser(PageState ps, BigDecimal userID) {
        Party party = null;
        try {
            party = (Party)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.kernel.Party", (Object)userID));
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("cannot find user", (Throwable)ex);
        }
        Group group = this.getGroup(ps);
        group.addMemberOrSubgroup(party);
        group.save();
    }
}

