/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ThreadCollection;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.web.Application;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.math.BigDecimal;

public class ThreadList
extends SimpleComponent
implements Constants {
    private IntegerParameter m_pageNumber = new IntegerParameter("page");
    private int m_pageSize = 15;
    static /* synthetic */ Class class$com$arsdigita$forum$ui$ThreadList;

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_pageNumber);
    }

    private ThreadCollection getThreads(PageState state) {
        ForumContext context = ForumContext.getContext(state);
        Party party = Kernel.getContext().getParty();
        Forum forum = context.getForum();
        BigDecimal categoryID = context.getCategorySelection();
        if (categoryID != null && categoryID.equals(Constants.TOPIC_ANY)) {
            categoryID = null;
        }
        ThreadCollection threads = forum.getThreads(categoryID, Kernel.getContext().getParty());
        return threads;
    }

    public void generateXML(PageState state, Element parent) {
        Element content = parent.newChildElement("forum:threadList", "http://www.arsdigita.com/forum/1.0");
        ThreadCollection threads = this.getThreads(state);
        Integer page = (Integer)state.getValue((ParameterModel)this.m_pageNumber);
        int pageNumber = page == null ? 1 : page;
        long objectCount = threads.size();
        int pageCount = (int)Math.ceil((double)objectCount / (double)this.m_pageSize);
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageNumber > pageCount) {
            pageNumber = pageCount == 0 ? 1 : pageCount;
        }
        long begin = (pageNumber - 1) * this.m_pageSize;
        int count = (int)Math.min((long)this.m_pageSize, objectCount - begin);
        long end = begin + (long)count;
        this.generatePaginatorXML(content, pageNumber, pageCount, this.m_pageSize, begin, end, objectCount);
        if (begin != 0L || end != 0L) {
            threads.setRange(new Integer((int)begin + 1), new Integer((int)end + 1));
        }
        while (threads.next()) {
            MessageThread thread = threads.getMessageThread();
            Element threadEl = content.newChildElement("forum:thread", "http://www.arsdigita.com/forum/1.0");
            ParameterMap map = new ParameterMap();
            map.setParameter("thread", (Object)thread.getID());
            URL url = URL.there((Application)((Application)Kernel.getContext().getResource()), (String)"/thread.jsp", (ParameterMap)map);
            threadEl.addAttribute("url", XML.format((Object)url));
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(threadEl);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk((DomainObject)thread, (class$com$arsdigita$forum$ui$ThreadList == null ? ThreadList.class$("com.arsdigita.forum.ui.ThreadList") : class$com$arsdigita$forum$ui$ThreadList).getName());
        }
    }

    protected void generatePaginatorXML(Element parent, int pageNumber, int pageCount, int pageSize, long begin, long end, long objectCount) {
        Element paginator = parent.newChildElement("forum:paginator", "http://www.arsdigita.com/forum/1.0");
        URL here = Web.getContext().getRequestURL();
        ParameterMap params = new ParameterMap(here.getParameterMap());
        params.clearParameter("page");
        URL url = new URL(here.getScheme(), here.getServerName(), here.getServerPort(), here.getContextPath(), here.getServletPath(), here.getPathInfo(), params);
        paginator.addAttribute("param", "page");
        paginator.addAttribute("baseURL", XML.format((Object)url));
        paginator.addAttribute("pageNumber", XML.format((Object)new Integer(pageNumber)));
        paginator.addAttribute("pageCount", XML.format((Object)new Integer(pageCount)));
        paginator.addAttribute("pageSize", XML.format((Object)new Integer(pageSize)));
        paginator.addAttribute("objectBegin", XML.format((Object)new Long(begin + 1L)));
        paginator.addAttribute("objectEnd", XML.format((Object)new Long(end)));
        paginator.addAttribute("objectCount", XML.format((Object)new Long(objectCount)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

