/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.categorization.CategorizedObject;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.ModerationAlert;
import com.arsdigita.forum.ThreadSubscription;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Post
extends ThreadedMessage {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$Post == null ? (class$com$arsdigita$forum$Post = Post.class$("com.arsdigita.forum.Post")) : class$com$arsdigita$forum$Post));
    public static final String STATUS = "status";
    public static final String MODERATOR = "moderator";
    public static final String PENDING = "pending";
    public static final String APPROVED = "approved";
    public static final String REJECTED = "rejected";
    public static final String REAPPROVE = "reapprove";
    public static final String SUPPRESSED = "suppressed";
    public static final String POST_STATUS_SUBQUERY = "com.arsdigita.forum.threadModerationStatus";
    private Party m_moderator;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.Post";
    static /* synthetic */ Class class$com$arsdigita$forum$Post;
    static /* synthetic */ Class class$com$arsdigita$forum$Forum;
    static /* synthetic */ Class class$java$math$BigDecimal;

    private Post() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected Post(String typeName) {
        super(typeName);
    }

    public Post(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Post(DataObject obj) {
        super(obj);
    }

    public static Post create(Forum forum) {
        return Post.create(forum, forum.isModerated() ? PENDING : APPROVED);
    }

    public static Post create(Forum forum, String status) {
        Post post = new Post();
        post.setup(forum, status);
        return post;
    }

    protected void setup(Forum forum, String status) {
        this.setForum(forum);
        this.setStatus(status);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Post replyToPost() {
        return (Post)this.replyTo();
    }

    public ThreadedMessage newInstance() {
        return Post.create(this.getForum());
    }

    protected void beforeSave() {
        Forum forum = this.getForum();
        Assert.exists((Object)((Object)forum), (Class)(class$com$arsdigita$forum$Forum == null ? (class$com$arsdigita$forum$Forum = Post.class$("com.arsdigita.forum.Forum")) : class$com$arsdigita$forum$Forum));
        BigDecimal id = this.getID();
        this.setRFCMessageID(id + ".bboard@" + Forum.getConfig().getReplyHostName());
        this.setReplyTo(this.getRefersTo() + ".bboard@" + Forum.getConfig().getReplyHostName());
        super.beforeSave();
    }

    protected void afterSave() {
        super.afterSave();
        Forum forum = this.getForum();
        MessageThread root = this.getThread();
        Assert.exists((Object)root);
        s_log.info((Object)("Setting context for " + this.getOID() + " to " + root.getOID()));
        PermissionService.setContext((ACSObject)this, (ACSObject)root);
        s_log.info((Object)("Setting context for " + root.getOID() + " to " + forum.getOID()));
        PermissionService.setContext((ACSObject)root, (ACSObject)forum);
    }

    public void sendNotifications() {
        KernelExcursion ex = new KernelExcursion(){

            protected void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Post.this.doSendNotifications();
            }
        };
        ex.run();
    }

    public void sendModeratorAlerts() {
        KernelExcursion ex = new KernelExcursion(){

            protected void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Post.this.doSendModeratorAlerts();
            }
        };
        ex.run();
    }

    private void doSendNotifications() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"sending user notifications");
        }
        Forum forum = this.getForum();
        if (this.getStatus().equals(APPROVED)) {
            ThreadSubscription sub;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Sending forum level subsriptions");
            }
            DataCollection subscriptions = forum.getSubscriptions();
            while (subscriptions.next()) {
                ForumSubscription subscription = (ForumSubscription)DomainObjectFactory.newInstance((DataObject)subscriptions.getDataObject());
                s_log.debug((Object)("notification to  " + subscription.getOID()));
                subscription.sendNotification(this);
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Sending thread level subsriptions");
            }
            if ((sub = ThreadSubscription.getThreadSubscription(this.getThread())) != null) {
                sub.sendNotification(this);
            } else {
                s_log.error((Object)("Got a null ThreadSubscription from Post # " + this.getID()));
            }
        } else if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Not sending notifications because the message is not approved");
        }
    }

    private void doSendModeratorAlerts() {
        Forum forum;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"sending moderator notice");
        }
        if ((forum = this.getForum()).isModerated()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Processing moderation alerts");
            }
            DataCollection alerts = forum.getModerationAlerts();
            while (alerts.next()) {
                ModerationAlert alert = (ModerationAlert)DomainObjectFactory.newInstance((DataObject)alerts.getDataObject());
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Processing moderation alert " + alert.getOID()));
                }
                alert.sendNotification(this);
            }
        } else if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Not sending moderator alerts because the forum is not moderated");
        }
    }

    public void setForum(Forum forum) {
        this.setRefersTo((ACSObject)forum);
    }

    public Forum getForum() {
        BigDecimal id = this.getRefersTo();
        Assert.exists((Object)id, (Class)(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Post.class$("java.math.BigDecimal")) : class$java$math$BigDecimal));
        return new Forum(id);
    }

    public void mapCategory(Category category) throws PersistenceException {
        if (this.isNew()) {
            throw new PersistenceException("Post must be persistent to map categories");
        }
        category.addChild((ACSObject)this);
        category.save();
    }

    public void clearCategories() {
        DataOperation clearCategories = SessionManager.getSession().retrieveDataOperation("com.arsdigita.forum.clearCategories");
        clearCategories.setParameter("postID", (Object)this.getID());
        clearCategories.execute();
    }

    public CategoryCollection getCategories() {
        return new CategorizedObject((ACSObject)this).getParents();
    }

    public void createThreadSubscription() {
        if (this.getRoot() == null) {
            ThreadSubscription sub = new ThreadSubscription();
            sub.setThread(this.getThread());
            sub.save();
        }
    }

    public boolean canEdit(Party party) {
        Party author = this.getFrom();
        return Forum.getConfig().canAuthorEditPosts() && author.equals((Object)party) || this.getForum().canEdit(party);
    }

    public void setStatus(String status) {
        Assert.truth((status.equals(APPROVED) || status.equals(REJECTED) || status.equals(REAPPROVE) || status.equals(SUPPRESSED) || status.equals(PENDING) ? 1 : 0) != 0, (String)("The status must be one of approved, rejected, reapprove, suppressed, the input was " + status));
        this.set(STATUS, status);
    }

    public String getStatus() {
        return (String)this.get(STATUS);
    }

    public void setModerator(Party moderator) {
        this.setAssociation(MODERATOR, (DomainObject)moderator);
    }

    public Party getModerator() {
        DataObject moderatorData;
        if (this.m_moderator == null && (moderatorData = (DataObject)this.get(MODERATOR)) != null) {
            this.m_moderator = (Party)DomainObjectFactory.newInstance((DataObject)moderatorData);
        }
        return this.m_moderator;
    }

    protected void beforeDelete() {
        ArrayList<DataObject> replies = new ArrayList<DataObject>();
        ArrayList<BigDecimal> msgIdList = new ArrayList<BigDecimal>();
        msgIdList.add(this.getID());
        if (this.getRoot() == null) {
            DataCollection msgs = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
            msgs.addEqualsFilter("root", (Object)this.getID());
            while (msgs.next()) {
                replies.add(msgs.getDataObject());
                msgIdList.add((BigDecimal)msgs.getDataObject().getOID().get("id"));
            }
        }
        DataCollection requests = SessionManager.getSession().retrieve(Notification.BASE_DATA_OBJECT_TYPE);
        requests.addFilter("messageID in :msgIdList").set("msgIdList", msgIdList);
        while (requests.next()) {
            Notification no = new Notification(requests.getDataObject().getOID());
            no.setMessageDelete(Boolean.FALSE);
            no.delete();
        }
        if (this.getRoot() == null) {
            ThreadSubscription sub = ThreadSubscription.getThreadSubscription(this);
            sub.delete();
            MessageThread thread = MessageThread.getFromRootMessage((ThreadedMessage)this);
            thread.delete();
            Iterator it = replies.iterator();
            while (it.hasNext()) {
                Post reply = new Post((DataObject)it.next());
                reply.delete();
            }
        }
        super.beforeDelete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

