/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.forum.Forum;
import com.arsdigita.forum.Post;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.AbstractPopulateApp;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;
import java.math.BigDecimal;
import java.util.List;

public class PopulateForum
extends AbstractPopulateApp
implements PopulateApp {
    private static final String ARGS_DESC = "2 PopulateForum args: numThreads, numMsgs";

    public void populateApp(List args) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        Forum forum = (Forum)this.getApp();
        this.validateArgs(args, 2, ARGS_DESC);
        int iThreads = (Integer)args.get(0);
        int iMsgs = (Integer)args.get(1);
        Assert.truth((iThreads >= 0 ? 1 : 0) != 0, (String)"iThreads must be >= 0");
        Assert.truth((iMsgs > 0 ? 1 : 0) != 0, (String)"iMsgs must be > 0");
        List users = Utilities.getUsersIDs((int)10);
        int iUsers = users.size();
        String sBaseTitle = Utilities.getBaseString((String)this.getBaseStringSeed());
        String sPostText = Utilities.makeTextBody();
        int iUserIndex = 0;
        for (int i = 0; i < iThreads; ++i) {
            txn.beginTxn();
            User u = User.retrieve((BigDecimal)((BigDecimal)users.get(iUserIndex)));
            iUserIndex = (iUserIndex + 1) % iUsers;
            Post rootPost = Post.create(forum);
            String sSubject = "Test Post" + sBaseTitle + i;
            rootPost.setSubject(sSubject);
            rootPost.setText(sPostText);
            rootPost.setFrom((Party)u);
            rootPost.save();
            rootPost.createThreadSubscription();
            this.s_log.info((Object)("Inserted Post " + sSubject));
            Post tmpPost = null;
            for (int j = 0; j < iMsgs - 1; ++j) {
                u = User.retrieve((BigDecimal)((BigDecimal)users.get(iUserIndex)));
                iUserIndex = (iUserIndex + 1) % iUsers;
                Post p = null;
                p = j % 2 == 0 ? (Post)rootPost.replyTo() : (Post)tmpPost.replyTo();
                sSubject = "Reply Test Post" + sBaseTitle + i;
                p.setForum(forum);
                p.setSubject(sSubject);
                p.setText(sPostText);
                p.setFrom((Party)u);
                p.save();
                this.s_log.info((Object)("Inserted Post " + sSubject));
                tmpPost = p;
            }
            txn.commitTxn();
        }
    }

    public String getArgsDescription() {
        return ARGS_DESC;
    }

    public ApplicationType getAppType() {
        ApplicationType appType = ApplicationType.retrieveApplicationTypeForApplication((String)"com.arsdigita.forum.Forum");
        if (this.s_log.isDebugEnabled()) {
            this.s_log.debug((Object)("returning app type " + appType.getApplicationObjectType()));
        }
        return appType;
    }

    protected String getPortletType() {
        return "com.arsdigita.forum.RecentPostingsPortlet";
    }
}

