/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ThreadComponent;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ThreadDisplay
extends SimpleComponent
implements Constants {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$ui$ThreadDisplay == null ? (class$com$arsdigita$forum$ui$ThreadDisplay = ThreadDisplay.class$("com.arsdigita.forum.ui.ThreadDisplay")) : class$com$arsdigita$forum$ui$ThreadDisplay));
    private IntegerParameter m_pageNumber = new IntegerParameter("page");
    private int m_pageSize = 10;
    private static final String ACTION_EDIT = "edit";
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_REPLY = "reply";
    private static final String ACTION_APPROVE = "approve";
    private static final String ACTION_REJECT = "reject";
    private ThreadComponent m_threadComponent;
    private ACSObjectSelectionModel m_post;
    static /* synthetic */ Class class$com$arsdigita$forum$ui$ThreadDisplay;

    public ThreadDisplay(ACSObjectSelectionModel post, ThreadComponent threadComponent) {
        this.m_threadComponent = threadComponent;
        this.m_post = post;
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_pageNumber);
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        OID oid = new OID("com.arsdigita.forum.Post", (Object)new BigDecimal(value));
        ForumContext ctx = ForumContext.getContext(state);
        Post post = (Post)DomainObjectFactory.newInstance((OID)oid);
        if (ACTION_EDIT.equals(key)) {
            this.m_post.setSelectedObject(state, (DomainObject)post);
            this.m_threadComponent.makeEditFormVisible(state);
        } else if (ACTION_DELETE.equals(key)) {
            Assert.truth((boolean)ctx.canAdminister(), (String)"can administer forums");
            MessageThread thread = ctx.getMessageThread();
            ThreadedMessage root = thread.getRootMessage();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("message: " + post.getOID() + " root: " + root.getOID() + " thread: " + thread.getOID()));
            }
            if (ctx.getForum().isModerated()) {
                if (!ctx.canModerate()) {
                    post.setStatus("suppressed");
                    post.save();
                } else {
                    if (post.equals(root)) {
                        s_log.debug((Object)"Deleting entire thread");
                        post.delete();
                        Forum forum = ctx.getForum();
                        URL url = URL.there((HttpServletRequest)state.getRequest(), (Application)forum, null);
                        throw new RedirectSignal(url, true);
                    }
                    s_log.debug((Object)"Deleting message");
                    post.delete();
                }
            } else {
                if (post.equals(root)) {
                    s_log.debug((Object)"Deleting entire thread");
                    post.delete();
                    Forum forum = ctx.getForum();
                    URL url = URL.there((HttpServletRequest)state.getRequest(), (Application)forum, null);
                    throw new RedirectSignal(url, true);
                }
                s_log.debug((Object)"Deleting message");
                post.delete();
            }
        } else if (ACTION_REPLY.equals(key)) {
            this.m_post.setSelectedObject(state, (DomainObject)post);
            this.m_threadComponent.makeReplyFormVisible(state);
        } else if (ACTION_APPROVE.equals(key)) {
            post.setStatus("approved");
            post.save();
            post.sendNotifications();
        } else if (ACTION_REJECT.equals(key)) {
            this.m_post.setSelectedObject(state, (DomainObject)post);
            this.m_threadComponent.makeRejectFormVisible(state);
        }
    }

    private DomainCollection getMessages(PageState state) {
        BigDecimal rootID = ForumContext.getContext(state).getMessageThread().getRootMessage().getID();
        DataCollection messages = SessionManager.getSession().retrieve("com.arsdigita.forum.Post");
        FilterFactory ff = messages.getFilterFactory();
        messages.addFilter((Filter)ff.or().addFilter((Filter)ff.and().addFilter(ff.equals("root", null)).addFilter(ff.equals("id", (Object)rootID))).addFilter(ff.equals("root", (Object)rootID)));
        messages.addOrderWithNull("sortKey", (Object)"---", true);
        ForumContext context = ForumContext.getContext(state);
        Party party = Kernel.getContext().getParty();
        Forum forum = context.getForum();
        if (forum.isModerated() && !forum.canModerate(party)) {
            messages.addFilter((Filter)ff.or().addFilter(ff.equals("status", (Object)"approved")).addFilter(ff.equals("sender.id", (Object)(party == null ? null : party.getID()))));
        }
        return new DomainCollection(messages);
    }

    public void generateXML(PageState state, Element parent) {
        Element content = parent.newChildElement("forum:threadDisplay", "http://www.arsdigita.com/forum/1.0");
        this.exportAttributes(content);
        Forum forum = ForumContext.getContext(state).getForum();
        content.addAttribute("forumTitle", forum.getTitle());
        DomainCollection messages = this.getMessages(state);
        Integer page = (Integer)state.getValue((ParameterModel)this.m_pageNumber);
        int pageNumber = page == null ? 1 : page;
        long objectCount = messages.size();
        int pageCount = (int)Math.ceil((double)objectCount / (double)this.m_pageSize);
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageNumber > pageCount) {
            pageNumber = pageCount == 0 ? 1 : pageCount;
        }
        long begin = (pageNumber - 1) * this.m_pageSize;
        int count = (int)Math.min((long)this.m_pageSize, objectCount - begin);
        long end = begin + (long)count;
        this.generatePaginatorXML(content, pageNumber, pageCount, this.m_pageSize, begin, end, objectCount);
        if (begin != 0L || end != 0L) {
            messages.setRange(new Integer((int)begin + 1), new Integer((int)end + 1));
        }
        while (messages.next()) {
            Post message = (Post)messages.getDomainObject();
            Element messageEl = content.newChildElement("forum:message", "http://www.arsdigita.com/forum/1.0");
            this.generateActionXML(state, messageEl, message);
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(messageEl);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk((DomainObject)message, (class$com$arsdigita$forum$ui$ThreadDisplay == null ? ThreadDisplay.class$("com.arsdigita.forum.ui.ThreadDisplay") : class$com$arsdigita$forum$ui$ThreadDisplay).getName());
        }
    }

    protected void generateActionXML(PageState state, Element parent, Post post) {
        Party party;
        ForumContext ctx = ForumContext.getContext(state);
        String status = post.getStatus();
        if (ctx.canModerate() && !status.equals("rejected") && !status.equals("suppressed")) {
            parent.addAttribute("rejectURL", this.makeURL(state, ACTION_REJECT, post));
        }
        if (ctx.canModerate()) {
            if (!post.getStatus().equals("approved")) {
                parent.addAttribute("approveURL", this.makeURL(state, ACTION_APPROVE, post));
            }
        }
        if (ctx.canAdminister()) {
            parent.addAttribute("deleteURL", this.makeURL(state, ACTION_DELETE, post));
        }
        if (post.canEdit(party = Kernel.getContext().getParty())) {
            parent.addAttribute("editURL", this.makeURL(state, ACTION_EDIT, post));
        }
        parent.addAttribute("replyURL", this.makeURL(state, ACTION_REPLY, post));
    }

    protected String makeURL(PageState state, String action, Post post) {
        state.setControlEvent((Component)this, action, post.getID().toString());
        String url = null;
        try {
            url = state.stateAsURL();
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot create url", (Throwable)ex);
        }
        state.clearControlEvent();
        return url;
    }

    protected void generatePaginatorXML(Element parent, int pageNumber, int pageCount, int pageSize, long begin, long end, long objectCount) {
        Element paginator = parent.newChildElement("forum:paginator", "http://www.arsdigita.com/forum/1.0");
        URL here = Web.getContext().getRequestURL();
        ParameterMap params = new ParameterMap(here.getParameterMap());
        params.clearParameter("page");
        URL url = new URL(here.getScheme(), here.getServerName(), here.getServerPort(), here.getContextPath(), here.getServletPath(), here.getPathInfo(), params);
        paginator.addAttribute("param", "page");
        paginator.addAttribute("baseURL", XML.format((Object)url));
        paginator.addAttribute("pageNumber", XML.format((Object)new Integer(pageNumber)));
        paginator.addAttribute("pageCount", XML.format((Object)new Integer(pageCount)));
        paginator.addAttribute("pageSize", XML.format((Object)new Integer(pageSize)));
        paginator.addAttribute("objectBegin", XML.format((Object)new Long(begin + 1L)));
        paginator.addAttribute("objectEnd", XML.format((Object)new Long(end)));
        paginator.addAttribute("objectCount", XML.format((Object)new Long(objectCount)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

