/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.CategoryView;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ForumAlertsView;
import com.arsdigita.forum.ui.ForumUserView;
import com.arsdigita.forum.ui.admin.ModerationView;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ForumComponent
extends ModalContainer
implements Constants {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$ui$ForumComponent == null ? (class$com$arsdigita$forum$ui$ForumComponent = ForumComponent.class$("com.arsdigita.forum.ui.ForumComponent")) : class$com$arsdigita$forum$ui$ForumComponent));
    public static final String MODE_THREADS = "threads";
    public static final String MODE_TOPICS = "topics";
    public static final String MODE_ALERTS = "alerts";
    public static final String MODE_MODERATION = "moderation";
    private StringParameter m_mode = new StringParameter("mode");
    private ModerationView m_moderationView = new ModerationView();
    private ForumAlertsView m_alertsView = new ForumAlertsView();
    private CategoryView m_topicView = new CategoryView();
    private ForumUserView m_userView = new ForumUserView();
    static /* synthetic */ Class class$com$arsdigita$forum$ui$ForumComponent;

    public ForumComponent() {
        super("forum:forum", "http://www.arsdigita.com/forum/1.0");
        this.add((Component)this.m_moderationView);
        this.add((Component)this.m_alertsView);
        this.add((Component)this.m_topicView);
        this.add((Component)this.m_userView);
        this.setDefaultComponent((Component)this.m_userView);
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_mode);
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        String mode = state.getControlEventValue();
        state.setValue((ParameterModel)this.m_mode, (Object)mode);
        if (MODE_TOPICS.equals(mode)) {
            this.setVisibleComponent(state, (Component)this.m_topicView);
        } else if (MODE_ALERTS.equals(mode)) {
            if (Kernel.getContext().getParty() == null) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
            this.setVisibleComponent(state, (Component)this.m_alertsView);
        } else if (MODE_MODERATION.equals(mode)) {
            Party party = Kernel.getContext().getParty();
            if (party == null) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
            Forum forum = ForumContext.getContext(state).getForum();
            PermissionDescriptor permission = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)forum, party);
            PermissionService.assertPermission((PermissionDescriptor)permission);
            this.setVisibleComponent(state, (Component)this.m_moderationView);
        } else {
            this.setVisibleComponent(state, (Component)this.m_userView);
        }
    }

    public void generateXML(PageState state, Element parent) {
        PermissionDescriptor permission;
        Element content = this.generateParent(parent);
        this.generateModeXML(state, content, MODE_THREADS);
        this.generateModeXML(state, content, MODE_TOPICS);
        this.generateModeXML(state, content, MODE_ALERTS);
        Forum forum = ForumContext.getContext(state).getForum();
        content.addAttribute("title", forum.getTitle());
        Party party = Kernel.getContext().getParty();
        if (party != null && PermissionService.checkPermission((PermissionDescriptor)(permission = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)forum, party)))) {
            this.generateModeXML(state, content, MODE_MODERATION);
        }
        this.generateChildrenXML(state, content);
    }

    protected void generateModeXML(PageState state, Element parent, String mode) {
        String current = (String)state.getValue((ParameterModel)this.m_mode);
        if (current == null) {
            current = MODE_THREADS;
        }
        Element content = parent.newChildElement("forum:forumMode", "http://www.arsdigita.com/forum/1.0");
        state.setControlEvent((Component)this, "mode", mode);
        content.addAttribute("mode", mode);
        try {
            content.addAttribute("url", state.stateAsURL());
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot create url", (Throwable)ex);
        }
        content.addAttribute("selected", current.equals(mode) ? "1" : "0");
        state.clearControlEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

