/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.forum.DailySubscription;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.ThreadSubscription;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.forum.ui.ThreadAlertsList;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class ForumAlertsView
extends SimpleContainer
implements Constants {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$ui$ForumAlertsView == null ? (class$com$arsdigita$forum$ui$ForumAlertsView = ForumAlertsView.class$("com.arsdigita.forum.ui.ForumAlertsView")) : class$com$arsdigita$forum$ui$ForumAlertsView));
    static /* synthetic */ Class class$com$arsdigita$forum$ui$ForumAlertsView;

    ForumAlertsView() {
        this.add(this.forumAlertsSegment());
        this.add(this.threadAlertsSegment());
    }

    private Component forumAlertsSegment() {
        SimpleContainer seg = new SimpleContainer("forum:forumAlerts", "http://www.arsdigita.com/forum/1.0");
        seg.add(this.forumAlertsForm());
        return seg;
    }

    private Component threadAlertsSegment() {
        SimpleContainer seg = new SimpleContainer("forum:threadAlerts", "http://www.arsdigita.com/forum/1.0");
        seg.add(this.threadAlertsForm());
        return seg;
    }

    private Component forumAlertsForm() {
        Form alertsForm = new Form("instantAlerts", (Container)new ColumnPanel(2));
        final RadioGroup instant = new RadioGroup("instant");
        instant.addOption(new Option("Yes"));
        instant.addOption(new Option("No"));
        alertsForm.add((Component)new Label(Text.gz("forum.ui.receive_instant_alerts")));
        alertsForm.add((Component)instant);
        final RadioGroup daily = new RadioGroup("daily");
        daily.addOption(new Option("Yes"));
        daily.addOption(new Option("No"));
        alertsForm.add((Component)new Label(Text.gz("forum.ui.receive_daily_summary")));
        alertsForm.add((Component)daily);
        alertsForm.add((Component)new Label(""));
        alertsForm.add((Component)new Submit("Save"));
        alertsForm.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) {
                FormData data = e.getFormData();
                PageState s = e.getPageState();
                Party party = Kernel.getContext().getParty();
                Forum forum = ForumContext.getContext(s).getForum();
                ForumSubscription fSub = ForumSubscription.getFromForum(forum);
                if (fSub.isSubscribed(party)) {
                    instant.setValue(s, (Object)"Yes");
                } else {
                    instant.setValue(s, (Object)"No");
                }
                DailySubscription dSub = (DailySubscription)DailySubscription.getFromForum(forum);
                if (dSub.isSubscribed(party)) {
                    daily.setValue(s, (Object)"Yes");
                } else {
                    daily.setValue(s, (Object)"No");
                }
            }
        });
        alertsForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                FormData data = e.getFormData();
                PageState s = e.getPageState();
                Party party = Kernel.getContext().getParty();
                Forum forum = ForumContext.getContext(s).getForum();
                ForumSubscription fSub = ForumSubscription.getFromForum(forum);
                DailySubscription dSub = (DailySubscription)DailySubscription.getFromForum(forum);
                if (data.get((Object)"instant").equals("Yes")) {
                    fSub.subscribe(party);
                } else if (data.get((Object)"instant").equals("No")) {
                    fSub.unsubscribe(party);
                } else {
                    throw new FormProcessException("Received bad option for instant: " + data.get((Object)"instant"));
                }
                fSub.save();
                if (data.get((Object)"daily").equals("Yes")) {
                    dSub.subscribe(party);
                } else if (data.get((Object)"daily").equals("No")) {
                    dSub.unsubscribe(party);
                } else {
                    throw new FormProcessException("Received bad option for daily: " + data.get((Object)"daily"));
                }
                dSub.save();
            }
        });
        return alertsForm;
    }

    private Component threadAlertsForm() {
        Form form = new Form("dailyAlerts");
        form.setRedirecting(true);
        form.add((Component)new ThreadAlertsList(){

            public Element generateAlertXML(ThreadSubscription sub) {
                Element subEl = super.generateAlertXML(sub);
                subEl.addAttribute("param", "delete");
                return subEl;
            }
        });
        CheckboxGroup boxes = new CheckboxGroup(new ArrayParameter((ParameterModel)new BigDecimalParameter("delete")));
        form.add((Component)boxes);
        form.add((Component)new Submit(Text.gz("forum.ui.delete")), 68);
        form.addProcessListener((FormProcessListener)new DeleteProcesser());
        return form;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DeleteProcesser
    implements FormProcessListener {
        DeleteProcesser() {
        }

        public void process(FormSectionEvent e) {
            FormData data = e.getFormData();
            PageState s = e.getPageState();
            Party party = Kernel.getContext().getParty();
            BigDecimal[] deletes = (BigDecimal[])data.get((Object)"delete");
            if (deletes != null) {
                for (int i = 0; i < deletes.length; ++i) {
                    try {
                        ThreadSubscription tSub = new ThreadSubscription(deletes[i]);
                        tSub.unsubscribe(party);
                        tSub.save();
                        continue;
                    }
                    catch (DataObjectNotFoundException x) {
                        throw new UncheckedWrapperException((Throwable)x);
                    }
                }
            }
        }
    }
}

