/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.domain.xml.TraversalHandler;
import com.arsdigita.forum.DailySubscription;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.ModerationAlert;
import com.arsdigita.forum.portlet.RecentPostingsPortlet;
import com.arsdigita.forum.ui.portlet.RecentPostingsPortletEditor;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLService;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.web.Application;
import com.arsdigita.web.ui.ApplicationConfigFormSection;
import com.arsdigita.xml.XML;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class Initializer
extends CompoundInitializer {
    public static final String versionId = "$Id: //apps/forum/dev/src/com/arsdigita/forum/Initializer.java#28 $$Author: dan $$DateTime: 2004/03/18 14:28:05 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$Initializer == null ? (class$com$arsdigita$forum$Initializer = Initializer.class$("com.arsdigita.forum.Initializer")) : class$com$arsdigita$forum$Initializer));
    static /* synthetic */ Class class$com$arsdigita$forum$Initializer;

    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
        this.add((com.arsdigita.runtime.Initializer)new PDLInitializer((PDLSource)new ManifestSource("ccm-forum.pdl.mf", (PDLFilter)new NameFilter(DbHelper.getDatabaseSuffix((int)database), "pdl"))));
    }

    public void init(DomainInitEvent e) {
        super.init(e);
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.Forum", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Forum(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.Inbox", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Forum(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.RecentPostingsPortlet", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new RecentPostingsPortlet(dataObject);
            }
        });
        e.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.forum.ForumSubscription", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                if (((Boolean)dataObject.get("isModerationAlert")).booleanValue()) {
                    s_log.debug((Object)"This is a mod alert");
                    return new ModerationAlert(dataObject);
                }
                s_log.debug((Object)"This is a subscription");
                if (dataObject.get("digest") == null) {
                    return new ForumSubscription(dataObject);
                }
                return new DailySubscription(dataObject);
            }
        });
        XML.parse((InputStream)Forum.getConfig().getTraversalAdapters(), (DefaultHandler)new TraversalHandler());
        URLFinder messageFinder = new URLFinder(){

            public String find(OID oid, String context) throws NoValidURLException {
                return this.find(oid);
            }

            public String find(OID oid) throws NoValidURLException {
                DataObject dobj = SessionManager.getSession().retrieve(oid);
                if (dobj == null) {
                    throw new NoValidURLException("No such data object " + oid);
                }
                Application app = Application.retrieveApplication((DataObject)dobj);
                if (app == null) {
                    throw new NoValidURLException("Could not find application instance for " + dobj);
                }
                try {
                    ThreadedMessage message = new ThreadedMessage(oid);
                    String url = app.getPath() + "/thread.jsp?threadID=" + message.getThread().getID().toString();
                    return url;
                }
                catch (DataObjectNotFoundException e) {
                    throw new NoValidURLException("Could not find application instance for " + dobj);
                }
            }
        };
        URLService.registerFinder((String)ThreadedMessage.BASE_DATA_OBJECT_TYPE, (URLFinder)messageFinder);
        new ResourceTypeConfig("com.arsdigita.forum.RecentPostingsPortlet"){

            public ResourceConfigFormSection getCreateFormSection(ResourceType resType, RequestLocal parentAppRL) {
                RecentPostingsPortletEditor config = new RecentPostingsPortletEditor(resType, parentAppRL);
                return config;
            }

            public ResourceConfigFormSection getModifyFormSection(RequestLocal application) {
                RecentPostingsPortletEditor config = new RecentPostingsPortletEditor(application);
                return config;
            }
        };
        new ResourceTypeConfig("com.arsdigita.forum.Forum"){

            public ResourceConfigFormSection getCreateFormSection(ResourceType resType, RequestLocal parentAppRL) {
                ApplicationConfigFormSection config = new ApplicationConfigFormSection(resType, parentAppRL);
                return config;
            }

            public ResourceConfigFormSection getModifyFormSection(RequestLocal application) {
                ApplicationConfigFormSection config = new ApplicationConfigFormSection(application);
                return config;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

