/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.page.BebopMapDispatcher;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ForumComponent;
import com.arsdigita.forum.ui.ThreadComponent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class BboardDispatcher
extends BebopMapDispatcher
implements Constants {
    public static final String versionId = "$Id: //apps/forum/dev/src/com/arsdigita/forum/BboardDispatcher.java#17 $$Author: dan $$DateTime: 2003/09/15 13:58:12 $";
    private static final String XSL_HOOK = "forum";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$BboardDispatcher == null ? (class$com$arsdigita$forum$BboardDispatcher = BboardDispatcher.class$("com.arsdigita.forum.BboardDispatcher")) : class$com$arsdigita$forum$BboardDispatcher));
    static /* synthetic */ Class class$com$arsdigita$forum$BboardDispatcher;

    public BboardDispatcher() {
        s_log.warn((Object)"BboardDispatcher created!");
        Page index = BboardDispatcher.buildForumPage(new BigDecimalParameter("topic"));
        this.addPage("", index);
        this.addPage("index.jsp", index);
        this.addPage("thread.jsp", BboardDispatcher.buildThreadPage(new BigDecimalParameter("thread")));
    }

    static Page buildThreadPage(BigDecimalParameter stateParam) {
        Page threadPage = PageFactory.buildPage((String)XSL_HOOK, (String)"Threads");
        threadPage.add((Component)new ThreadComponent());
        threadPage.addGlobalStateParam((ParameterModel)stateParam);
        threadPage.addRequestListener((RequestListener)new ThreadPageRequestListener(stateParam));
        threadPage.lock();
        return threadPage;
    }

    static Page buildForumPage(BigDecimalParameter stateParam) {
        Page page = PageFactory.buildPage((String)XSL_HOOK, (String)"Forum");
        ForumComponent forumComp = new ForumComponent();
        page.add((Component)forumComp);
        page.addGlobalStateParam((ParameterModel)stateParam);
        page.addRequestListener((RequestListener)new ForumPageRequestListener(stateParam, forumComp));
        page.lock();
        return page;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ForumPageRequestListener
    implements RequestListener {
        private BigDecimalParameter m_categorySelection;
        private ForumComponent m_forumComp;

        public ForumPageRequestListener(BigDecimalParameter categorySelection, ForumComponent forumComp) {
            this.m_categorySelection = categorySelection;
            this.m_forumComp = forumComp;
        }

        public void pageRequested(RequestEvent event) {
            PageState state = event.getPageState();
            ForumContext context = ForumContext.getContext(state);
            context.setCategorySelection((BigDecimal)event.getPageState().getValue((ParameterModel)this.m_categorySelection));
        }
    }

    private static class ThreadPageRequestListener
    implements RequestListener {
        private BigDecimalParameter m_threadID;

        public ThreadPageRequestListener(BigDecimalParameter threadID) {
            this.m_threadID = threadID;
        }

        public void pageRequested(RequestEvent event) {
            PageState state = event.getPageState();
            ForumContext context = ForumContext.getContext(state);
            context.setThreadID((BigDecimal)event.getPageState().getValue((ParameterModel)this.m_threadID));
        }
    }
}

