/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;

import com.arsdigita.persistence.DataQuery;

import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.web.ParameterMap;

import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;

import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;

import java.math.BigDecimal;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;


public class TopicList extends SimpleComponent implements Constants {

    private static Set s_catProps;
    static {
        s_catProps = new HashSet();
        s_catProps.add("id");
        s_catProps.add("latestPost");
        s_catProps.add("numThreads");
        s_catProps.add("name");
    }
    
    public void generateXML(PageState state,
                            Element parent) {
        Element content = parent.newChildElement("forum:topicList", 
                                                 FORUM_XML_NS);
        exportAttributes(content);
        
        URL url = URL.request(state.getRequest(), null);
        content.addAttribute("baseURL", url.toString());
        content.addAttribute("param", TOPIC_PARAM);

        Forum forum = ForumContext.getContext(state).getForum();
        DataQuery categories = forum.getCategories();
        generateQueryXML(content, categories);

        DataQuery unCategory = forum.getUnCategory();
        while (unCategory.next()) {
            Element noTopic = content.newChildElement("forum:noTopicSummary", 
                                                      FORUM_XML_NS);

            Element id = noTopic.newChildElement("id");
            id.setText(XML.format(TOPIC_NONE));

            Element latestPost = noTopic.newChildElement("latestPost");
            latestPost.setText(XML.format(unCategory.get("latestPost")));

            Element numThreads = noTopic.newChildElement("numThreads");
            numThreads.setText(XML.format(unCategory.get("numThreads")));
        }
    }    
    
    
    public void generateQueryXML(Element parent,
                                 DataQuery query) {
        while (query.next()) {
            Element content = parent.newChildElement("forum:topicSummary", 
                                                     FORUM_XML_NS);

            Iterator keys = s_catProps.iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = query.get(key);
                if (value == null) {
                    continue;
                }

                Element attr = content.newChildElement(key);
                attr.setText(XML.format(value));
            }
        }
    }
}

