/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.forum.Post;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.xml.Element;
import com.arsdigita.toolbox.ui.FormatStandards;
import com.arsdigita.util.HtmlToText;

import org.apache.log4j.Logger;

/** Displays the details of one message or a Post */

class MessageView extends SimpleComponent implements Constants {
    private static final Logger s_log = Logger.getLogger(MessageView.class);

    private ACSObjectSelectionModel m_postModel;
    private Post m_post;

    /** For dynamically selected message views */
    public MessageView(ACSObjectSelectionModel postModel) {
        m_postModel = postModel;
    }

    public MessageView(Post post) {
        m_post = post;
    }

    public void register(Page page) {
        super.register(page);
        if (m_postModel != null) {
            page.addComponentStateParam(this, 
                                        m_postModel.getStateParameter());
        }
    }

    public void generateXML(PageState state,
                            Element parent) {
        Post post = m_post;
        if (m_post == null) {
            post = (Post)m_postModel.getSelectedObject(state);
        }
        
        Element messageEl = parent.newChildElement("forum:message", 
                                                   FORUM_XML_NS);
        exportAttributes(messageEl);

        DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(messageEl);
        xr.setWrapRoot(false);
        xr.setWrapAttributes(true);
        xr.setWrapObjects(false);
        
        xr.walk(post, ThreadDisplay.class.getName());
    }
}

