/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;


import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.categorization.Category;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;


/**
 * <b><font color="red">Experimental</font></b>
 * class to create form to add categories and map them to the forum
 * parent category. temporary hack for testing purposes
 *
 * @author <a href=mailto:sarah@arsdigita.com>Sarah Barwig</a>
 * @version $Revision: #8 $ $Author: dan $ $DateTime: 2003/09/15 13:58:12 $
 */
public class CategoryAddForm extends Form {
    public static final String versionId =
        "$Id: //apps/forum/dev/src/com/arsdigita/forum/ui/CategoryAddForm.java#8 $" +
        "$Author: dan $" +
        "$DateTime: 2003/09/15 13:58:12 $";

    private static final Logger s_log = Logger.getLogger
        (CategoryAddForm.class);

    private TextField m_name;
    private TextArea m_description;

    /**
     * Builds a form to add a category.
     */
    public CategoryAddForm() {
        super("categoryAdd");
        setRedirecting(true);

        add(new Label(Text.gz("forum.ui.name")));
        m_name = new TextField("name");
        m_name.addValidationListener(new NotNullValidationListener());
        add(m_name);

        add(new Label(Text.gz("forum.ui.description")));
        m_description = new TextArea("description");
        m_description.setRows(5);
        m_description.setCols(60);
        m_description.setWrap(TextArea.SOFT);
        add(m_description);

        Submit submit = new Submit("Create topic");
        add(submit);

        /*
         * Listener to process form data.  Just adds the categories, then
         * adds mappings.
         */
        addProcessListener
            (new FormProcessListener() {
                    public void process( FormSectionEvent e ) {
                        PageState state = e.getPageState();
                        
                        Forum forum = ForumContext.getContext(state).getForum();

                        String name = (String)m_name.getValue(state);
                        String description = (String)m_description.getValue(state);

                        Category topic = new Category();
                        topic.setName(name);
                        topic.setDescription(description);
                        topic.save();

                        Category parent = forum.getRootCategory();
                        parent.addChild(topic);
                        parent.save();
                        topic.setDefaultParentCategory(parent);
                        topic.save();

                        fireCompletionEvent(state);
                    }
                });

        /*
         * Generates the object id for the new category
         */
        addInitListener
            (new FormInitListener() {
                    public void init( FormSectionEvent e ) {
                        PageState state = e.getPageState();
                        FormData data = e.getFormData();

                        if ( Kernel.getContext().getParty() == null ) {
                            UserContext.redirectToLoginPage(state.getRequest());
                        }
                    }
                }
             );
    }
}
