/*
 * Copyright (C) 2001, 2002 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 */
 
package com.arsdigita.forum;

import java.math.BigDecimal;
import java.util.List;

import com.arsdigita.forum.portlet.RecentPostingsPortlet;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.AbstractPopulateApp;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;

/**
 * @author bche
 */
public class PopulateForum extends AbstractPopulateApp implements PopulateApp {

    private static final String ARGS_DESC = 
        "2 PopulateForum args: numThreads, numMsgs";        

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#populateApp(int[])
     */
    public void populateApp(List args) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();

        Forum forum = (Forum) getApp();

        //validate the arguments
        this.validateArgs(args, 2, ARGS_DESC);

        int iThreads = ((Integer)args.get(0)).intValue();
        int iMsgs = ((Integer)args.get(1)).intValue();

        Assert.truth(iThreads >= 0, "iThreads must be >= 0");
        Assert.truth(iMsgs > 0, "iMsgs must be > 0");

        //get users to make posts
        List users = Utilities.getUsersIDs(10);
        int iUsers = users.size();

        String sBaseTitle = Utilities.getBaseString(getBaseStringSeed());
        String sPostText = Utilities.makeTextBody();
        int iUserIndex = 0;

        for (int i = 0; i < iThreads; i++) {
            txn.beginTxn();

            //get the user for the post
            User u = User.retrieve((BigDecimal) users.get(iUserIndex));
            iUserIndex = (iUserIndex + 1) % iUsers;

            //create the initial post
            Post rootPost = Post.create(forum);
            String sSubject = "Test Post" + sBaseTitle + i;
            rootPost.setSubject(sSubject);
            rootPost.setText(sPostText);
            rootPost.setFrom(u);
            rootPost.save();
            rootPost.createThreadSubscription();

            s_log.info("Inserted Post " + sSubject);

            Post tmpPost = null;
            for (int j = 0; j < iMsgs - 1; j++) {
                u = User.retrieve((BigDecimal) users.get(iUserIndex));
                iUserIndex = (iUserIndex + 1) % iUsers;

                Post p = null;

                //we'll stagger replying to the previous post or to the root post
                if (j % 2 == 0) {
                    p = (Post)rootPost.replyTo();
                } else {
                    p = (Post)tmpPost.replyTo();
                }
                sSubject = "Reply Test Post" + sBaseTitle + i;
                p.setForum(forum);
                p.setSubject(sSubject);
                p.setText(sPostText);
                p.setFrom(u);
                p.save();

                s_log.info("Inserted Post " + sSubject);

                tmpPost = p;
            }

            txn.commitTxn();
        }

    }
    
    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getArgsDescription()
     */
    public String getArgsDescription() {
        return ARGS_DESC;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getAppType()
     */
    public ApplicationType getAppType() {
        ApplicationType appType =
            ApplicationType.retrieveApplicationTypeForApplication(
                Forum.BASE_DATA_OBJECT_TYPE);
        if (s_log.isDebugEnabled()) {
            s_log.debug(
                "returning app type " + appType.getApplicationObjectType());
        }
        return appType;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.AbstractPopulateApp#getPortletType()
     */
    protected String getPortletType() {
        return RecentPostingsPortlet.BASE_DATA_OBJECT_TYPE;
    }
}
