/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;

import com.arsdigita.domain.SimpleDomainObjectXMLFormatter;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.messaging.Message;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.HtmlToText;


public class MessageXMLFormatter 
    extends SimpleDomainObjectXMLFormatter {
    
    public String format(DomainObject obj,
                         String path,
                         Property prop,
                         Object value) {
        if (obj instanceof Message &&
            prop.getName().equals(Message.BODY)) {
            Message msg = (Message)obj;
            return msg.getBodyAsHTML();
        }
        return super.format(obj, path, prop, value);
    }
}
