/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormCancelListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ThreadSubscription;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.EditPostForm;
import com.arsdigita.forum.ui.ReplyToPostForm;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.forum.ui.ThreadDisplay;
import com.arsdigita.forum.ui.admin.RejectionForm;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.messaging.MessageThread;
import org.apache.log4j.Logger;

public class ThreadComponent
extends ModalContainer
implements Constants {
    private Container m_threadView;
    private Form m_editForm;
    private Form m_replyForm;
    private Form m_rejectForm;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$ui$ThreadComponent == null ? (class$com$arsdigita$forum$ui$ThreadComponent = ThreadComponent.class$("com.arsdigita.forum.ui.ThreadComponent")) : class$com$arsdigita$forum$ui$ThreadComponent));
    private ACSObjectSelectionModel m_postModel = new ACSObjectSelectionModel("post");
    static /* synthetic */ Class class$com$arsdigita$forum$ui$ThreadComponent;

    public ThreadComponent() {
        this.initComponents();
    }

    private void initComponents() {
        this.m_editForm = new EditPostForm(this.m_postModel);
        this.m_replyForm = new ReplyToPostForm(this.m_postModel);
        this.m_rejectForm = new RejectionForm(this.m_postModel);
        this.addForm(this.m_editForm);
        this.addForm(this.m_replyForm);
        this.addForm(this.m_rejectForm);
        this.m_threadView = new SimpleContainer();
        SimpleContainer linksPanel = new SimpleContainer("forum:threadOptions", "http://www.arsdigita.com/forum/1.0");
        Link returnLink = new Link((Component)new Label(Text.gz("forum.ui.threads.viewAll")), "index.jsp");
        returnLink.setClassAttr("actionLink");
        linksPanel.add((Component)returnLink);
        SimpleContainer subLinks = new SimpleContainer();
        subLinks.add(this.createThreadSubscribeLink());
        subLinks.add(this.createThreadUnsubscribeLink());
        linksPanel.add((Component)subLinks);
        this.m_threadView.add((Component)linksPanel);
        this.m_threadView.add((Component)new ThreadDisplay(this.m_postModel, this));
        this.add((Component)this.m_threadView);
        this.setDefaultComponent((Component)this.m_threadView);
    }

    public void makeListViewVisible(PageState state) {
        this.setVisibleComponent(state, (Component)this.m_threadView);
    }

    public void makeEditFormVisible(PageState state) {
        this.setVisibleComponent(state, (Component)this.m_editForm);
    }

    public void makeReplyFormVisible(PageState state) {
        s_log.debug((Object)"making reply form invisible");
        this.setVisibleComponent(state, (Component)this.m_replyForm);
    }

    public void makeRejectFormVisible(PageState state) {
        this.setVisibleComponent(state, (Component)this.m_rejectForm);
    }

    private final void addForm(Form form) {
        this.add((Component)form);
        form.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                s_log.debug((Object)"FORM ACTION COMPLETED");
                ThreadComponent.this.makeListViewVisible(e.getPageState());
            }
        });
        form.addCancelListener(new FormCancelListener(){

            public void cancel(FormSectionEvent e) {
                s_log.debug((Object)"fire cancel listener");
                PageState ps = e.getPageState();
                ThreadComponent.this.makeListViewVisible(e.getPageState());
            }
        });
    }

    private Component createThreadSubscribeLink() {
        ActionLink subscribeLink = new ActionLink((Component)new Label(Text.gz("forum.ui.thread.subscribe"))){

            public boolean isVisible(PageState s) {
                Party party = Kernel.getContext().getParty();
                if (party != null) {
                    ThreadSubscription sub = ThreadSubscription.getThreadSubscription(ThreadComponent.this.getCurrentMessage(s));
                    return !sub.isSubscribed(party);
                }
                return false;
            }
        };
        subscribeLink.setClassAttr("actionLink");
        subscribeLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                Party party = Kernel.getContext().getParty();
                ThreadSubscription sub = ThreadSubscription.getThreadSubscription(ThreadComponent.this.getCurrentMessage(s));
                if (!sub.isSubscribed(party)) {
                    sub.subscribe(party);
                }
                sub.save();
            }
        });
        return subscribeLink;
    }

    private Component createThreadUnsubscribeLink() {
        ActionLink unsubscribeLink = new ActionLink((Component)new Label(Text.gz("forum.ui.thread.unsubscribe"))){

            public boolean isVisible(PageState s) {
                Party party = Kernel.getContext().getParty();
                if (party != null) {
                    ThreadSubscription sub = ThreadSubscription.getThreadSubscription(ThreadComponent.this.getCurrentMessage(s));
                    return sub.isSubscribed(party);
                }
                return false;
            }
        };
        unsubscribeLink.setClassAttr("actionLink");
        unsubscribeLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                Party party = Kernel.getContext().getParty();
                ThreadSubscription sub = ThreadSubscription.getThreadSubscription(ThreadComponent.this.getCurrentMessage(s));
                if (sub.isSubscribed(party)) {
                    sub.unsubscribe(party);
                }
                sub.save();
            }
        });
        return unsubscribeLink;
    }

    private final ACSObjectSelectionModel getPostModel() {
        return this.m_postModel;
    }

    private MessageThread getCurrentMessage(PageState state) {
        return ForumContext.getContext(state).getMessageThread();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

