/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormStep;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Wizard;
import com.arsdigita.bebop.event.FormCancelListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.toolbox.ui.TextTypeWidget;
import com.arsdigita.util.HtmlToText;
import com.arsdigita.xml.Element;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class PostForm
extends Wizard
implements Constants {
    public static final String versionId = "$Id: //apps/forum/dev/src/com/arsdigita/forum/ui/PostForm.java#8 $$Author: dan $$DateTime: 2003/09/15 13:58:12 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$ui$PostForm == null ? (class$com$arsdigita$forum$ui$PostForm = PostForm.class$("com.arsdigita.forum.ui.PostForm")) : class$com$arsdigita$forum$ui$PostForm));
    private TextField m_subject;
    private TextArea m_body;
    private TextTypeWidget m_bodyType;
    static /* synthetic */ Class class$com$arsdigita$forum$ui$PostForm;

    public PostForm(String name) {
        super(name, (Container)new SimpleContainer());
    }

    protected void setupComponent() {
        this.add(this.dataEntryStep());
        this.add(this.confirmStep());
        this.addInitListener(new PostInitListener());
        this.addProcessListener(new PostProcessListener());
        this.addCancelListener(new PostCancelListener());
    }

    protected void setSubject(PageState state, String text) {
        this.m_subject.setValue(state, (Object)text);
    }

    protected Container dataEntryStep() {
        FormStep initial = new FormStep("initial", (Container)new SimpleContainer("forum:postForm", "http://www.arsdigita.com/forum/1.0"));
        this.m_subject = new TextField((ParameterModel)new StringParameter("subject"));
        this.m_subject.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.m_subject.addValidationListener((ParameterListener)new StringLengthValidationListener(250));
        this.m_subject.setSize(60);
        initial.add((Component)this.m_subject);
        this.m_body = new TextArea((ParameterModel)new StringParameter("message"), 8, 60, 2);
        this.m_body.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.m_body.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        initial.add((Component)this.m_body);
        this.m_bodyType = new TextTypeWidget((ParameterModel)new StringParameter("bodyType"), "text/plain");
        initial.add((Component)this.m_bodyType);
        return initial;
    }

    protected Container confirmStep() {
        SimpleContainer postContainer = new SimpleContainer("forum:postConfirm", "http://www.arsdigita.com/forum/1.0"){

            public void generateXML(PageState state, Element parent) {
                Element content = this.generateParent(parent);
                Element subject = content.newChildElement("subject");
                subject.setText((String)PostForm.this.m_subject.getValue(state));
                Element body = content.newChildElement("body");
                body.setText(HtmlToText.generateHTMLText((String)((String)PostForm.this.m_body.getValue(state)), (String)((String)PostForm.this.m_bodyType.getValue(state))));
            }
        };
        return postContainer;
    }

    protected abstract Post getPost(PageState var1, boolean var2);

    protected void initWidgets(PageState state, Post post) {
        if (post != null) {
            this.m_subject.setValue(state, (Object)post.getSubject());
            this.m_body.setValue(state, (Object)post.getBody());
            this.m_bodyType.setValue(state, (Object)post.getBodyType());
        }
    }

    protected void processWidgets(PageState state, Post post) {
        post.setSubject((String)this.m_subject.getValue(state));
        post.setBody((String)this.m_body.getValue(state), (String)this.m_bodyType.getValue(state));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PostCancelListener
    implements FormCancelListener {
        private PostCancelListener() {
        }

        public void cancel(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            PostForm.this.fireCompletionEvent(state);
        }
    }

    private class PostProcessListener
    implements FormProcessListener {
        private PostProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Post post = PostForm.this.getPost(state, true);
            PostForm.this.processWidgets(state, post);
            post.sendNotifications();
            post.sendModeratorAlerts();
            post.save();
            PostForm.this.fireCompletionEvent(state);
        }
    }

    private class PostInitListener
    implements FormInitListener {
        private PostInitListener() {
        }

        public void init(FormSectionEvent e) {
            PageState state = e.getPageState();
            if (Kernel.getContext().getParty() == null) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
            PostForm.this.initWidgets(state, PostForm.this.getPost(state, false));
        }
    }
}

