/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.Subscription;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;

public class ThreadSubscription
extends Subscription {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.ThreadSubscription";
    private static final String THREAD = "thread";
    private MessageThread m_thread = null;

    public ThreadSubscription() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ThreadSubscription(String objectType) {
        super(objectType);
    }

    public ThreadSubscription(DataObject dataObj) {
        super(dataObj);
    }

    public ThreadSubscription(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ThreadSubscription(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Post getThread() {
        return (Post)this.getThreadReal().getRootMessage();
    }

    public MessageThread getThreadReal() {
        DataObject threadData;
        if (this.m_thread == null && (threadData = (DataObject)this.get(THREAD)) != null) {
            this.m_thread = new MessageThread(threadData);
        }
        return this.m_thread;
    }

    public void doWriteCheck() {
        this.getThread().assertPrivilege(PrivilegeDescriptor.READ);
    }

    public void setThread(Post post) {
        this.setThread(post.getThread());
    }

    public void setThread(MessageThread thread) {
        this.m_thread = thread;
        this.setAssociation(THREAD, (DomainObject)thread);
    }

    protected void afterSave() {
        PermissionService.setContext((ACSObject)this, (ACSObject)this.getThreadReal());
        PermissionService.setContext((ACSObject)this.getGroup(), (ACSObject)this.getThreadReal());
        super.afterSave();
    }

    protected void beforeDelete() {
        DataCollection notifications = SessionManager.getSession().retrieve(Notification.BASE_DATA_OBJECT_TYPE);
        notifications.addEqualsFilter("partyTo", (Object)this.getGroup().getID());
        while (notifications.next()) {
            Notification no = new Notification(notifications.getDataObject().getOID());
            no.setMessageDelete(Boolean.FALSE);
            no.delete();
        }
        super.beforeDelete();
    }

    public static ThreadSubscription getThreadSubscription(Post post) {
        return ThreadSubscription.getThreadSubscription(post.getThread());
    }

    public static ThreadSubscription getThreadSubscription(MessageThread thread) {
        DataCollection subs = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        subs.addEqualsFilter("thread.id", (Object)thread.getID());
        ThreadSubscription sub = null;
        if (subs.next()) {
            sub = new ThreadSubscription(subs.getDataObject());
        }
        subs.close();
        return sub;
    }

    public static DomainCollection getSubsForUser(Party party) {
        DataQuery subs = SessionManager.getSession().retrieveQuery("com.arsdigita.forum.getUserThreadSubscriptions");
        subs.setParameter("userID", (Object)party.getID());
        return new DomainCollection((DataCollection)new DataQueryDataCollectionAdapter(subs, "subscription")){

            public DomainObject getDomainObject() {
                return new ThreadSubscription(this.m_dataCollection.getDataObject());
            }
        };
    }

    public String getSignature(Post post) {
        return SEPARATOR + "This is an automated alert from the Discussion Forum system. " + "You are receiving this email because you subscribed to " + "alerts on this thread.\n\n" + "Replying to this email will add a post to the forum. It will not send email directly to the person who posted this message.\n\n" + ThreadSubscription.getReturnURLMessage(post);
    }
}

