/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.Subscription;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ForumSubscription
extends Subscription {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$ForumSubscription == null ? (class$com$arsdigita$forum$ForumSubscription = ForumSubscription.class$("com.arsdigita.forum.ForumSubscription")) : class$com$arsdigita$forum$ForumSubscription));
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.ForumSubscription";
    public static final String IS_MODERATION_ALERT = "isModerationAlert";
    public static final String FORUM = "forum";
    private Forum m_forum;
    static /* synthetic */ Class class$com$arsdigita$forum$ForumSubscription;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$forum$Forum;

    public ForumSubscription(Forum forum) {
        this(BASE_DATA_OBJECT_TYPE, forum);
        this.setIsModerationAlert(false);
    }

    public ForumSubscription(String typeName, Forum forum) {
        super(typeName);
        Assert.exists((Object)typeName, (Class)(class$java$lang$String == null ? (class$java$lang$String = ForumSubscription.class$("java.lang.String")) : class$java$lang$String));
        Assert.exists((Object)((Object)forum), (Class)(class$com$arsdigita$forum$Forum == null ? (class$com$arsdigita$forum$Forum = ForumSubscription.class$("com.arsdigita.forum.Forum")) : class$com$arsdigita$forum$Forum));
        this.setForum(forum);
    }

    protected ForumSubscription(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected ForumSubscription(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected ForumSubscription(DataObject data) {
        super(data);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Forum getForum() {
        DataObject forumData;
        if (this.m_forum == null && (forumData = (DataObject)this.get(FORUM)) != null) {
            this.m_forum = (Forum)DomainObjectFactory.newInstance((DataObject)forumData);
        }
        return this.m_forum;
    }

    public void doWriteCheck() {
        this.getForum().assertPrivilege(PrivilegeDescriptor.READ);
    }

    private void setForum(Forum forum) {
        this.m_forum = forum;
        this.setAssociation(FORUM, (DomainObject)this.m_forum);
    }

    protected void afterSave() {
        PermissionService.setContext((ACSObject)this, (ACSObject)this.getForum());
        super.afterSave();
    }

    public String getSignature(ThreadedMessage post) {
        StringBuffer sb = new StringBuffer();
        sb.append(ForumSubscription.getReturnURLMessage((Post)post));
        return sb.toString();
    }

    public static ForumSubscription getFromForum(Forum forum) {
        DataCollection subs = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        subs.addEqualsFilter("forum.id", (Object)forum.getID());
        subs.addEqualsFilter("digest.id", null);
        if (subs.next()) {
            ForumSubscription sub = new ForumSubscription(subs.getDataObject());
            subs.close();
            return sub;
        }
        return null;
    }

    public void setIsModerationAlert(boolean isModerationAlert) {
        this.set(IS_MODERATION_ALERT, new Boolean(isModerationAlert));
    }

    public void setIsModerationAlert(Boolean isModerationAlert) {
        this.set(IS_MODERATION_ALERT, isModerationAlert);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

