/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.Forum;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;

import java.io.IOException;
import java.math.BigDecimal;

import org.apache.log4j.Logger;

/**
 * @see com.arsdigita.forum.Post.java 
 * @see com.arsdigita.forum.EditPostForm.java 
 */

class NewPostForm extends PostForm {
    public static final String versionId =
        "$Id: //apps/forum/dev/src/com/arsdigita/forum/ui/NewPostForm.java#7 $" +
        "$Author: dan $" +
        "$DateTime: 2003/09/15 13:58:12 $";

    private static final Logger s_log = Logger.getLogger(NewPostForm.class);

    private CategoryWidget m_category;

    public NewPostForm() {
        super("newPostForm");
        setupComponent();
    }

    protected Container dataEntryStep() {
        Container initial = super.dataEntryStep();
    
        m_category = new CategoryWidget(new BigDecimalParameter("topic"));
        initial.add(m_category);

        return initial;
    }

    protected Post getPost(PageState state,
                           boolean create) {
        if (!create) {
            return null;
        }
        
        Post post = Post.create(ForumContext.getContext(state).getForum());
        post.setFrom(Kernel.getContext().getParty());
        return post;
    }    

    protected void initWidgets(PageState state,
                               Post post) {
        super.initWidgets(state, post);
    }

    protected void processWidgets(PageState state,
                                  Post post) {
        super.processWidgets(state,
                             post);

        post.clearCategories();
        BigDecimal categoryID = (BigDecimal)m_category.getValue(state);
        if (categoryID != null && 
            !categoryID.equals(Constants.TOPIC_NONE)) {
            
            post.mapCategory(new Category(categoryID));
        }

        ForumContext ctx = ForumContext.getContext(state);
        Forum forum = ctx.getForum();
        if (forum.isModerated() &&
            !ctx.canModerate()) {
            post.setStatus(Post.PENDING);
        } else {
            post.setStatus(Post.APPROVED);
        }
        
        // XXX we shouldn't have to save the post yet 
        // just to create a subscription :-(
        post.save();
        post.createThreadSubscription();
    }
}
