/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.kernel.Party;

public class ThreadCollection extends DomainCollection {

    public ThreadCollection(DataCollection data) {
        super(data);
    }

    public MessageThread getMessageThread() {
        return (MessageThread)getDomainObject();
    }

    public void filterUnapproved(Party party) {
        Filter f = addInSubqueryFilter
            ("id", Post.POST_STATUS_SUBQUERY);
        f.set("status", Post.APPROVED);
        f.set("partyID", party == null ? null : party.getID());        
    }
}
