/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui.portlet;

import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.kernel.ResourceType;

import com.arsdigita.bebop.portal.PortletConfigFormSection;

import com.arsdigita.portal.Portlet;
import com.arsdigita.forum.portlet.RecentPostingsPortlet;


public class RecentPostingsPortletEditor extends PortletConfigFormSection {

    private TextField m_count;
    
    public RecentPostingsPortletEditor(ResourceType resType,
                                       RequestLocal parentAppRL) {
        super(resType, parentAppRL);
    }
    
    public RecentPostingsPortletEditor(RequestLocal application) {
        super(application);
    }


    protected void addWidgets() {
        super.addWidgets();

        m_count = new TextField(new IntegerParameter("count"));
        m_count.setSize(5);
        m_count.addValidationListener(new NotNullValidationListener());
        m_count.setHint("Enter the maximum number of posts to display");
        add(new Label("Max number of posts:", Label.BOLD), ColumnPanel.RIGHT);
        add(m_count);

    }
    
    protected void initWidgets(PageState state,
                               Portlet portlet)
        throws FormProcessException {
        super.initWidgets(state, portlet);
        
        if (portlet != null) {
            RecentPostingsPortlet myportlet = (RecentPostingsPortlet)portlet;
            
            m_count.setValue(state, myportlet.getNumPosts());
        } else {
            m_count.setValue(state, new Integer(5));
        }
    }
    
    protected void processWidgets(PageState state,
                                  Portlet portlet)
        throws FormProcessException {
        super.processWidgets(state, portlet);
        
        RecentPostingsPortlet myportlet = (RecentPostingsPortlet)portlet;
        
        myportlet.setNumPosts((Integer)m_count.getValue(state));
    }
}
