/*
 * Copyright (C) 2001, 2002 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.PageState;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;



public abstract class GroupMemberDisplay extends MembersDisplay {

    protected abstract Group getGroup(PageState ps);

    protected DataQuery getUsers(PageState ps) {
        Group group = getGroup(ps);
        return group.getContainedParties();
    }

    protected String getDisplayName( DataQuery q ) {
        Party party = ((PartyCollection)q).getParty();
        return party.getDisplayName();
    }

    protected String getKey( DataQuery q ) {
        Party party = ((PartyCollection)q).getParty();
        return party.getID().toString();
    }

    protected void removeUser( PageState ps, BigDecimal userID ) {
        Party party = null;
        
        try {
            party = (Party)DomainObjectFactory.newInstance(
                new OID(Party.BASE_DATA_OBJECT_TYPE,
                        userID));
        } catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("cannot find user", ex);
        }
        
        Group group = getGroup(ps);
        group.removeMemberOrSubgroup(party);
        group.save();
    }

}
