/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;

import java.math.BigDecimal;

/**
 * This interface holds constants used in bboard:
 * XML namespaces, URLs, URL variable names, etc.
 *
 *  @author <a href="mailto:teadams@arsdigita.com">Tracy Adams</a>
 *  @version $Revision: #7 $ $Date: 2003/09/15 $
 *  @since ACS 4.7
 */

public interface Constants {

    static final String FORUM_XML_NS = "http://www.arsdigita.com/forum/1.0";

    static final String FORUM_MODE_VIEW = "view";
    static final String FORUM_MODE_POST = "post";
    
    static final String MODE_PARAM = "mode";
    static final String THREAD_PARAM = "thread";
    static final String TOPIC_PARAM = "topic";
    static final String PAGINATOR_PARAM = "page";

    static final BigDecimal TOPIC_ANY = new BigDecimal(-1);
    static final BigDecimal TOPIC_NONE = new BigDecimal(-2);


}
