/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.forum.ui.Constants;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.page.BebopApplicationServlet;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;<a href="mailto:jross@redhat.com">jross@redhat.com</a>&gt;
 * @version $Id: //apps/forum/dev/src/com/arsdigita/forum/ForumServlet.java#6 $
 */
public class ForumServlet extends BebopApplicationServlet
        implements Constants {
    public static final String versionId =
        "$Id: //apps/forum/dev/src/com/arsdigita/forum/ForumServlet.java#6 $" +
        "$Author: dan $" +
        "$DateTime: 2003/09/15 13:58:12 $";

    private static final Logger s_log = Logger.getLogger(ForumServlet.class);

    public void init() throws ServletException {
        super.init();

        final Page forum = BboardDispatcher.buildForumPage
            (new BigDecimalParameter(TOPIC_PARAM));
        final Page thread = BboardDispatcher.buildThreadPage
            (new BigDecimalParameter(THREAD_PARAM));

        put("/", forum);
        put("/index.jsp", forum);
        put("/thread.jsp", thread);
    }
}
