/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.DailySubscription;
import com.arsdigita.forum.ForumConfig;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.ModerationAlert;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ThreadCollection;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Forum
extends Application {
    public static final String versionId = "$Id: //apps/forum/dev/src/com/arsdigita/forum/Forum.java#24 $$Author: sskracic $$DateTime: 2004/06/04 17:59:27 $";
    private static ForumConfig s_config = new ForumConfig();
    private static final Logger s_log;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.Forum";
    public static final String PACKAGE_TYPE = "forum";
    public static final String FORUM_MODERATION_PRIVILEGE = "forum_moderation";
    private static final String POSTS = "posts";
    private static final String SUBSCRIPTIONS = "subscriptions";
    private static final String MODERATION = "isModerated";
    private static final String MODERATION_GROUP = "moderationGroup";
    private static final String CATEGORY = "category";
    private boolean m_wasNew;
    static /* synthetic */ Class class$com$arsdigita$forum$Forum;
    static /* synthetic */ Class class$com$arsdigita$categorization$Category;
    static /* synthetic */ Class class$com$arsdigita$kernel$Party;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;

    public static ForumConfig getConfig() {
        return s_config;
    }

    public Forum(DataObject data) {
        super(data);
    }

    public Forum(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Forum(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static Forum create(String urlName, String title, Application parent) {
        return Forum.create(urlName, title, parent, false);
    }

    public static Forum create(String urlName, String title, Application parent, boolean moderated) {
        s_log.debug((Object)("creating forum " + title));
        Forum forum = (Forum)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent);
        forum.setModerated(moderated);
        return forum;
    }

    private void setRootCategory(Category category) {
        Assert.exists((Object)category, (Class)(class$com$arsdigita$categorization$Category == null ? (class$com$arsdigita$categorization$Category = Forum.class$("com.arsdigita.categorization.Category")) : class$com$arsdigita$categorization$Category));
        this.setAssociation(CATEGORY, (DomainObject)category);
    }

    public Category getRootCategory() {
        DataObject category = (DataObject)this.get(CATEGORY);
        if (category == null) {
            return this.createRootCategory();
        }
        return (Category)DomainObjectFactory.newInstance((DataObject)category);
    }

    private Category createRootCategory() {
        Category category = new Category(this.getTitle(), "Root category for forum " + this.getTitle());
        category.save();
        this.setRootCategory(category);
        return category;
    }

    private void createModerationGroup() {
        Group moderators = new Group();
        moderators.setName(this.getTitle() + " Moderators");
        this.setAssociation(MODERATION_GROUP, (DomainObject)moderators);
        String email = "forum-moderator-" + this.getID() + "-" + moderators.getID() + "@" + s_config.getReplyHostName();
        moderators.setPrimaryEmail(new EmailAddress(email));
    }

    public void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.setModerated(false);
            this.createRootCategory();
            this.createModerationGroup();
        }
    }

    protected void beforeSave() {
        this.m_wasNew = this.isNew();
        super.beforeSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterSave() {
        if (this.m_wasNew) {
            PermissionService.setContext((ACSObject)this.getRootCategory(), (ACSObject)this);
            if (this.getModerationGroup() != null) {
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)FORUM_MODERATION_PRIVILEGE), (ACSObject)this, (Party)this.getModerationGroup()));
            }
            KernelExcursion excursion = new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                }
            };
            excursion.run();
        }
        DataCollection subs = null;
        try {
            subs = this.getSubscriptions();
            if (subs.isEmpty()) {
                this.createSubscriptions();
            }
        }
        finally {
            if (null != subs) {
                subs.close();
            }
        }
        super.afterSave();
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public DataCollection getAllSubscriptions() {
        DataAssociationCursor dac = ((DataAssociation)this.get(SUBSCRIPTIONS)).cursor();
        return dac;
    }

    public DataCollection getSubscriptions() {
        DataCollection subs = this.getAllSubscriptions();
        subs.addEqualsFilter("isModerationAlert", (Object)Boolean.FALSE);
        return subs;
    }

    public DataCollection getModerationAlerts() {
        DataCollection subs = this.getAllSubscriptions();
        subs.addEqualsFilter("isModerationAlert", (Object)Boolean.TRUE);
        return subs;
    }

    public DataAssociation getPosts() {
        return (DataAssociation)this.get(POSTS);
    }

    public ThreadCollection getThreads() {
        return this.getThreads((BigDecimal)null);
    }

    public ThreadCollection getThreads(Party party) {
        ThreadCollection threads = this.getThreads();
        if (this.isModerated() && !this.canModerate(party)) {
            s_log.debug((Object)"Only showing approved threads");
            threads.filterUnapproved(party);
        }
        return threads;
    }

    public ThreadCollection getThreads(BigDecimal categoryID) {
        DataCollection threadsData = SessionManager.getSession().retrieve("com.arsdigita.messaging.Thread");
        threadsData.addEqualsFilter("root.objectID", (Object)this.getID());
        if (categoryID != null) {
            if (categoryID.equals(Constants.TOPIC_NONE)) {
                Filter f = threadsData.addNotInSubqueryFilter("root.id", "com.arsdigita.forum.uncategoryObject");
            } else {
                Filter f = threadsData.addInSubqueryFilter("root.id", "com.arsdigita.forum.categoryObject");
                f.set("categoryID", (Object)categoryID);
            }
        }
        threadsData.addOrder("lastUpdate desc");
        return new ThreadCollection(threadsData);
    }

    public ThreadCollection getThreads(BigDecimal categoryID, Party party) {
        ThreadCollection threads = this.getThreads(categoryID);
        if (this.isModerated() && !this.canModerate(party)) {
            s_log.debug((Object)"Only showing approved threads");
            threads.filterUnapproved(party);
        }
        return threads;
    }

    protected void createSubscriptions() {
        s_log.debug((Object)"Creating subscriptions!");
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                User party = Forum.getConfig().getDigestUser();
                Assert.exists((Object)party, (Class)(class$com$arsdigita$kernel$Party == null ? (class$com$arsdigita$kernel$Party = Forum.class$("com.arsdigita.kernel.Party")) : class$com$arsdigita$kernel$Party));
                new ForumSubscription(Forum.this).save();
                new DailySubscription(Forum.this, (Party)party).save();
                Group moderators = Forum.this.getModerationGroup();
                if (null != moderators) {
                    s_log.debug((Object)("creatiing moderation subscription " + moderators.getName()));
                    new ModerationAlert(Forum.this, moderators).save();
                }
            }
        }.run();
    }

    public DataQuery getCategories() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.forum.getCategorizationSummary");
        query.setParameter("forumID", (Object)this.getID());
        return query;
    }

    public DataQuery getEmptyCategories() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.forum.getUnusedCategories");
        query.setParameter("forumID", (Object)this.getID());
        return query;
    }

    public DataQuery getUnCategory() {
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.forum.getUncategorizedSummary");
        query.setParameter("forumID", (Object)this.getID());
        return query;
    }

    public DataAssociationCursor getFilledCategories() {
        Category root = this.getRootCategory();
        DataAssociationCursor cursor = root.getRelatedCategories("child");
        Filter f = cursor.addInSubqueryFilter("id", "com.arsdigita.forum.filledCategories");
        return cursor;
    }

    public boolean hasCategorizedPosts(Category cat) {
        ThreadCollection children = this.getThreads(cat.getID());
        return children.size() != 0L;
    }

    public boolean canEdit(Party party) {
        return Forum.getConfig().canAdminEditPosts() && PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.EDIT, (ACSObject)this, party));
    }

    public boolean canAdminister(Party party) {
        return PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)this, party));
    }

    public boolean canModerate(Party party) {
        return PermissionService.checkPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.get((String)FORUM_MODERATION_PRIVILEGE), (ACSObject)this, party));
    }

    public void setModerated(boolean moderate) {
        Boolean old = (Boolean)this.get(MODERATION);
        if (Boolean.TRUE.equals(old) && !moderate) {
            DataAssociationCursor posts = this.getPosts().cursor();
            posts.addEqualsFilter("status", (Object)"pending");
            while (posts.next()) {
                Post post = (Post)DomainObjectFactory.newInstance((DataObject)posts.getDataObject());
                post.setStatus("approved");
                post.save();
            }
        }
        this.set(MODERATION, new Boolean(moderate));
    }

    public boolean isModerated() {
        Boolean isModerated = (Boolean)this.get(MODERATION);
        Assert.exists((Object)isModerated);
        return isModerated;
    }

    public Group getModerationGroup() {
        DataObject dObj = (DataObject)this.get(MODERATION_GROUP);
        Assert.exists((Object)dObj, (Class)(class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = Forum.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject));
        return (Group)DomainObjectFactory.newInstance((DataObject)dObj);
    }

    public String getContextPath() {
        return "/ccm-forum";
    }

    public String getServletPath() {
        return "/main";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_config.load();
        s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$Forum == null ? (class$com$arsdigita$forum$Forum = Forum.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$forum$Forum));
    }
}

