/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormStep;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Wizard;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.messaging.Message;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.notification.Notification;
import com.arsdigita.util.StringUtils;
import org.apache.log4j.Logger;

public class RejectionForm
extends Wizard
implements Constants {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$ui$admin$RejectionForm == null ? (class$com$arsdigita$forum$ui$admin$RejectionForm = RejectionForm.class$("com.arsdigita.forum.ui.admin.RejectionForm")) : class$com$arsdigita$forum$ui$admin$RejectionForm));
    private ACSObjectSelectionModel m_postModel;
    private Notification m_notification;
    private TextArea m_textArea;
    protected static final String ALERT_BLURB = "This is an automated notice from the Discussion Forum system. ";
    protected static final String SEPARATOR = "\n\n" + StringUtils.repeat((char)'-', (int)20) + "\n\n";
    static /* synthetic */ Class class$com$arsdigita$forum$ui$admin$RejectionForm;

    public RejectionForm(ACSObjectSelectionModel postModel) {
        super("postRejectionForm");
        this.m_postModel = postModel;
        this.add((Container)this.dataEntryStep());
        this.add(this.confirmStep());
        this.addInitListener(new RejectionInitListener());
        this.addProcessListener(new RejectionProcessListener());
    }

    private FormStep dataEntryStep() {
        FormStep form = new FormStep("initial", (Container)new BoxPanel(2));
        form.add((Component)new Label("Message"));
        this.m_textArea = new TextArea("bodyText");
        form.add((Component)this.m_textArea);
        return form;
    }

    private Container confirmStep() {
        BoxPanel confirm = new BoxPanel(2);
        Label subject = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Post post = (Post)RejectionForm.this.m_postModel.getSelectedObject(state);
                Label l = (Label)e.getTarget();
                l.setLabel(RejectionForm.this.getHeader(post));
            }
        });
        Label body = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Post post = (Post)RejectionForm.this.m_postModel.getSelectedObject(state);
                Label l = (Label)e.getTarget();
                l.setOutputEscaping(false);
                String body = StringUtils.quoteHtml((String)RejectionForm.this.getBody(post, state));
                l.setLabel("<pre>" + body + "</pre>");
            }
        });
        Label sig = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Post post = (Post)RejectionForm.this.m_postModel.getSelectedObject(state);
                Label l = (Label)e.getTarget();
                l.setLabel(RejectionForm.this.getSignature());
            }
        });
        confirm.add((Component)subject);
        confirm.add((Component)body);
        confirm.add((Component)sig);
        return confirm;
    }

    private String getHeader(Post post) {
        StringBuffer header = new StringBuffer();
        header.append("Forum    : ");
        header.append(post.getForum().getDisplayName()).append("\n");
        header.append("Subject  : ");
        header.append(post.getSubject()).append("\n\n");
        return header.toString();
    }

    private String getBody(Post post, PageState state) {
        StringBuffer body = new StringBuffer();
        body.append("Your message has been rejected by the moderator.\n");
        body.append("The moderator has given the following reasons:\n\n");
        body.append((String)this.m_textArea.getValue(state));
        body.append("\n\n");
        body.append("The content of the message follows:\n\n");
        body.append("Subject: " + post.getSubject() + "\n");
        body.append(post.getBody() + "\n\n\n");
        return body.toString();
    }

    private String getSignature() {
        StringBuffer sig = new StringBuffer();
        sig.append(SEPARATOR);
        sig.append(ALERT_BLURB);
        return sig.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RejectionProcessListener
    implements FormProcessListener {
        private RejectionProcessListener() {
        }

        public void process(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            Post post = (Post)RejectionForm.this.m_postModel.getSelectedObject(state);
            MessageThread thread = ForumContext.getContext(state).getMessageThread();
            ThreadedMessage root = thread.getRootMessage();
            if (RejectionForm.this.getFinish().isSelected(state)) {
                if (post.equals(root)) {
                    s_log.debug((Object)"Suppressing entire thread");
                    post.setStatus("suppressed");
                } else {
                    s_log.debug((Object)"rejecting message");
                    post.setStatus("rejected");
                }
                post.save();
                String msg = (String)RejectionForm.this.m_textArea.getValue(state);
                if (msg != null && !"".equals(msg.trim())) {
                    this.sendNotice(post, state);
                } else {
                    s_log.info((Object)"Skipping notification because message is empty");
                }
            }
            RejectionForm.this.fireCompletionEvent(state);
        }

        private void sendNotice(Post post, PageState state) {
            Forum forum = ForumContext.getContext(state).getForum();
            Notification notice = new Notification();
            notice.setTo(post.getFrom());
            notice.setHeader(RejectionForm.this.getHeader(post));
            Message message = new Message();
            Group noticeSender = forum.getModerationGroup();
            if (noticeSender == null) {
                noticeSender = post.getModerator();
            }
            message.setFrom((Party)noticeSender);
            message.setSubject("Moderation notice " + post.getForum().getDisplayName());
            message.setBody(RejectionForm.this.getBody(post, state), "text/plain");
            notice.setMessage(message);
            notice.setSignature(RejectionForm.this.getSignature());
            s_log.debug((Object)("sending notification" + message + "\n to: " + post.getFrom().getName()));
            notice.save();
        }
    }

    private class RejectionInitListener
    implements FormInitListener {
        private RejectionInitListener() {
        }

        public void init(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            RejectionForm.this.m_textArea.setValue(state, (Object)"");
        }
    }
}

