/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Text;
import org.apache.log4j.Logger;

public class ModerationFormSection
extends FormSection {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$forum$ui$admin$ModerationFormSection == null ? (class$com$arsdigita$forum$ui$admin$ModerationFormSection = ModerationFormSection.class$("com.arsdigita.forum.ui.admin.ModerationFormSection")) : class$com$arsdigita$forum$ui$admin$ModerationFormSection));
    private Label m_statusOn;
    private Label m_statusOff;
    private Submit m_switchOn;
    private Submit m_switchOff;
    private Label m_warning;
    static /* synthetic */ Class class$com$arsdigita$forum$ui$admin$ModerationFormSection;

    public ModerationFormSection() {
        super((Container)new ColumnPanel(3));
        this.addWidgets();
        this.addProcessListener(new ModFormProcessListener());
        this.addInitListener(new ModForumInitListener());
    }

    public void addWidgets() {
        this.add((Component)new Label(Text.gz("forum.ui.moderate.label")));
        this.m_statusOn = new Label(Text.gz("forum.ui.moderate.status.on"));
        this.m_statusOff = new Label(Text.gz("forum.ui.moderate.status.off"));
        this.add((Component)this.m_statusOn);
        this.add((Component)this.m_statusOff);
        this.m_switchOn = new Submit(Text.gz("forum.ui.moderate.switch.on"));
        this.m_switchOff = new Submit(Text.gz("forum.ui.moderate.switch.off"));
        this.add((Component)this.m_switchOn);
        this.add((Component)this.m_switchOff);
        this.m_warning = new Label(Text.gz("forum.ui.moderate.warning"));
        this.add((Component)this.m_warning, 64);
    }

    private void calculateVisibility(PageState state) {
        Forum forum = ForumContext.getContext(state).getForum();
        boolean moderated = forum.isModerated();
        this.m_statusOn.setVisible(state, moderated);
        this.m_statusOff.setVisible(state, !moderated);
        this.m_switchOn.setVisible(state, !moderated);
        this.m_switchOff.setVisible(state, moderated);
        this.m_warning.setVisible(state, moderated);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModForumInitListener
    implements FormInitListener {
        private ModForumInitListener() {
        }

        public void init(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            ModerationFormSection.this.calculateVisibility(state);
        }
    }

    private class ModFormProcessListener
    implements FormProcessListener {
        private ModFormProcessListener() {
        }

        public void process(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            Forum forum = ForumContext.getContext(state).getForum();
            if (ModerationFormSection.this.m_switchOn.isSelected(state)) {
                s_log.debug((Object)"Switch on pressed");
                forum.setModerated(true);
            } else if (ModerationFormSection.this.m_switchOff.isSelected(state)) {
                s_log.debug((Object)"Switch off pressed");
                forum.setModerated(false);
            } else {
                s_log.debug((Object)"Something else pressed");
            }
            ModerationFormSection.this.calculateVisibility(state);
        }
    }
}

