/*
 * Copyright (C) 2001, 2002 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 */
 
package com.arsdigita.faq;

import java.util.List;

import com.arsdigita.faq.ui.FaqQuestionsPortlet;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.AbstractPopulateApp;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;

/**
 * @author bche
 */
public class PopulateFaq extends AbstractPopulateApp implements PopulateApp {
    private static final String ARGS_DESC = "1 PopulateFaq arg: numQuestions";

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#populateApp(java.util.List)
     */
    public void populateApp(List args) {        
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();

        Faq faq = (Faq) getApp();

        //validate the arguments
        this.validateArgs(args, 1, ARGS_DESC);

        int iQuestions = ((Integer)args.get(0)).intValue();
        Assert.assertTrue(iQuestions >= 0, "iQuestions must be >= 0");
        
        //populate the FAQ
        for (int i=0; i < iQuestions; i++) {
            txn.beginTxn();
            String sQuestion = "This is question " + i;
            String sAnswer = Utilities.makeText(i);
            
            QAPair pair = faq.createQuestion(sQuestion, sAnswer);
            s_log.info("created FAQ question " + i);
            
            txn.commitTxn();
        }
        
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getArgsDescription()
     */
    public String getArgsDescription() {
        return ARGS_DESC;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getAppType()
     */
    public ApplicationType getAppType() {        
        return ApplicationType.retrieveApplicationTypeForApplication(Faq.BASE_DATA_OBJECT_TYPE);        
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.AbstractPopulateApp#getPortletType()
     */
    protected String getPortletType() {
        return FaqQuestionsPortlet.BASE_DATA_OBJECT_TYPE;
    }

}
