/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.faq;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.TypedText;

import com.arsdigita.web.Application;

import java.math.BigDecimal;

/**
 * Faq class.
 *
 */

public class Faq extends Application {

    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/Faq.java#4 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.faq.Faq";

    private static final org.apache.log4j.Logger log =
        org.apache.log4j.Logger.getLogger(Faq.class);

    public Faq(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Faq(BigDecimal key)  throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, key));
    }

    public Faq(DataObject dataObject) {
        super(dataObject);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }


    /**
     * Use this instead of the constructor to create new Faq objects
     */
    public static Faq create(String urlName, String title,
                             Application parent) {
        return (Faq) Application.createApplication
            (BASE_DATA_OBJECT_TYPE, urlName, title, parent);
    }

    public QAPair createQuestion(String question, String answer) {
        return createQuestion(question,
                              new TypedText(answer, TypedText.TEXT_HTML));
    }

    /**
     * @deprecated use createQuestion(String, TypedText) instead
     */
    public QAPair createQuestion(String question, String answer,
                                 String answerFormat) {
        return createQuestion(question, new TypedText(answer, answerFormat));
    }

    public QAPair createQuestion(String question, TypedText answer) {

        Integer sortKey = getNextSortKey();
        QAPair qaPair = new QAPair();
        qaPair.setFaq(this);
        qaPair.setQuestion(question);
        qaPair.setAnswer(answer);
        qaPair.setSortKey(sortKey);
        qaPair.save();
        PermissionService.setContext(qaPair, this);

        return qaPair;
    }


    void removeQAPair(QAPair qaPair) {
        remove("questions", qaPair);
    }

    public DataAssociation getQAPairs() {
        return (DataAssociation) get("questions");
    }

    /*
     * XXX synchronization is not really enough.  need to lock the
     * database or risk an error.
     * (Actually, there's no unique constraint on sort key, so
     *  you won't get an error)
     */
    synchronized Integer getNextSortKey() {
        DataQuery nextVal = SessionManager.getSession().
            retrieveQuery("com.arsdigita.faq.nextSortKey");
        nextVal.setParameter("faqID", getID());

        Integer returnVal = null;
        if (nextVal.next()) {
            returnVal = (Integer) nextVal.get("nextSortKey");
        } else {
            // this should never happen
            throw new RuntimeException("No rows returned from a query "
                                       + "guaranteed to return a row");
        }

        nextVal.close();
        return returnVal;
    }

    /**
     * Swaps the order of two questions
     */
    void swapOrder(QAPair qaPairA, QAPair qaPairB) {

        if (qaPairA.getFaq().equals(this) && qaPairB.getFaq().equals(this)) {

            log.debug("Security passed, swapping: ");

            Integer temp = qaPairA.getSortKey();
            qaPairA.setSortKey(qaPairB.getSortKey());
            qaPairB.setSortKey(temp);

            qaPairA.save();
            qaPairB.save();

            log.debug("Swapped: ");
        }

    }

}
