/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.faq.ui;

import com.arsdigita.faq.QAPair;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.SimpleContainer;

public class QAView extends SimpleContainer {

    public static final String versionId = "$Id: //apps/faq/dev/src/com/arsdigita/faq/ui/QAView.java#2 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    public QAView(QAPair qa) {
        this(qa.getQuestion(), qa.getAnswer().getHTMLText());
    }

    public QAView(String question, String answer) {
        this(new Label(question), new Label(answer));
    }

    public QAView(Label question, Label answer) {
        super("faq:question-answer-pair", FaqPage.FAQ_XML_NS);

        question.setClassAttr("question");
        add(question);

        answer.setClassAttr("answer");
        answer.setOutputEscaping(false);
        add(answer);
    }
}
